/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.nlp.sempre.test;

import edu.stanford.nlp.sempre.Formula;
import edu.stanford.nlp.sempre.JavaExecutor;
import edu.stanford.nlp.sempre.NumberValue;
import edu.stanford.nlp.sempre.Value;
import edu.stanford.nlp.sempre.Values;
import org.testng.AssertJUnit;
import org.testng.annotations.Test;

public class JavaExecutorTest {
    JavaExecutor executor = new JavaExecutor();

    private static Formula F(String s) {
        return Formula.fromString(s);
    }

    private static Value V(double x) {
        return new NumberValue(x);
    }

    private static Value V(String x) {
        return Values.fromString(x);
    }

    @Test
    public void numbers() {
        AssertJUnit.assertEquals((Object)JavaExecutorTest.V(8.0), (Object)this.executor.execute((Formula)JavaExecutorTest.F((String)"(call + (number 3) (number 5))"), null).value);
        AssertJUnit.assertEquals((Object)JavaExecutorTest.V(6.0), (Object)this.executor.execute((Formula)JavaExecutorTest.F((String)"(call + (call - (number 10) (number 9)) (number 5))"), null).value);
        AssertJUnit.assertEquals((Object)JavaExecutorTest.V(1.0), (Object)this.executor.execute((Formula)JavaExecutorTest.F((String)"(call java.lang.Math.cos (number 0))"), null).value);
        AssertJUnit.assertEquals((Object)JavaExecutorTest.V(1.0), (Object)this.executor.execute((Formula)JavaExecutorTest.F((String)"((lambda x (call java.lang.Math.cos (var x))) (number 0))"), null).value);
    }

    @Test
    public void conditionals() {
        AssertJUnit.assertEquals((Object)JavaExecutorTest.V("(string no)"), (Object)this.executor.execute((Formula)JavaExecutorTest.F((String)"(call if (boolean false) (string yes) (string no))"), null).value);
        AssertJUnit.assertEquals((Object)JavaExecutorTest.V("(string yes)"), (Object)this.executor.execute((Formula)JavaExecutorTest.F((String)"(call if (call < (number 3) (number 4)) (string yes) (string no))"), null).value);
    }

    @Test
    public void strings() {
        AssertJUnit.assertEquals((Object)JavaExecutorTest.V(5.0), (Object)this.executor.execute((Formula)JavaExecutorTest.F((String)"(call .length (string hello))"), null).value);
        AssertJUnit.assertEquals((Object)JavaExecutorTest.V("(string abcdef)"), (Object)this.executor.execute((Formula)JavaExecutorTest.F((String)"(call .concat (string abc) (string def))"), null).value);
    }

    @Test
    public void higherOrder() {
        AssertJUnit.assertEquals((Object)JavaExecutorTest.V("(list (number 10) (number 40))"), (Object)this.executor.execute((Formula)JavaExecutorTest.F((String)"(call map (list (number 1) (number 4)) (lambda x (call * (number 10) (var x))))"), null).value);
        AssertJUnit.assertEquals((Object)JavaExecutorTest.V("(list (number 4))"), (Object)this.executor.execute((Formula)JavaExecutorTest.F((String)"(call select (list (number 1) (number 4)) (lambda x (call == (number 0) (call % (var x) (number 2)))))"), null).value);
    }
}

