/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.nlp.sempre.test;

import edu.stanford.nlp.sempre.BeamParser;
import edu.stanford.nlp.sempre.Builder;
import edu.stanford.nlp.sempre.Example;
import edu.stanford.nlp.sempre.Json;
import edu.stanford.nlp.sempre.Params;
import edu.stanford.nlp.sempre.Parser;
import edu.stanford.nlp.sempre.StringValue;
import edu.stanford.nlp.sempre.test.ParserTest;
import edu.stanford.nlp.sempre.test.TestUtils;
import fig.basic.LogInfo;
import org.testng.annotations.Test;

public class JsonTest {
    public static String S(Object o) {
        return Json.writeValueAsStringHard(o);
    }

    public static <T> T D(String s, Class<T> klass) {
        return Json.readValueHard(s, klass);
    }

    public static <T> T D(String s, Class<T> klass, Class<?> view) {
        return Json.readValueHard(s, klass, view);
    }

    public static boolean exampleEquals(Example a, Example b) {
        if (!a.id.equals(b.id)) {
            return false;
        }
        if (!a.utterance.equals(b.utterance)) {
            return false;
        }
        if (a.context != b.context && !a.context.equals(b.context)) {
            return false;
        }
        if (a.targetFormula != b.targetFormula && !a.targetFormula.toString().equals(b.targetFormula.toString())) {
            return false;
        }
        return a.targetValue == b.targetValue || a.targetValue.equals(b.targetValue);
    }

    public static Parser makeSimpleBeamParser() {
        return new BeamParser(ParserTest.ABCTest().getParserSpec());
    }

    @Test
    public void testExample() {
        Builder builder = new Builder();
        builder.build();
        Example.Builder b = new Example.Builder();
        Example ex = b.setId("id").setUtterance("A is for Alice").setTargetValue(new StringValue("B is for Bob")).createExample();
        LogInfo.log((Object)JsonTest.S(ex));
        assert (JsonTest.exampleEquals(ex, JsonTest.D(JsonTest.S(ex), Example.class)));
        ex.preprocess();
        LogInfo.log((Object)JsonTest.S(ex));
        assert (ex.languageInfo != null);
        assert (!ex.languageInfo.tokens.isEmpty());
        assert (JsonTest.exampleEquals(ex, JsonTest.D(JsonTest.S(ex), Example.class)));
        ex = TestUtils.makeSimpleExample("1 2 3");
        ex.preprocess();
        JsonTest.makeSimpleBeamParser().parse(new Params(), ex, true);
        String there = JsonTest.S(ex);
        Example back = JsonTest.D(there, Example.class);
        String thereAgain = JsonTest.S(back);
        LogInfo.log((Object)there);
        LogInfo.log((Object)thereAgain);
        assert (there.equals(thereAgain));
        assert (JsonTest.exampleEquals(ex, back));
    }
}

