/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.nlp.sempre.test;

import edu.stanford.nlp.sempre.BeamParser;
import edu.stanford.nlp.sempre.Derivation;
import edu.stanford.nlp.sempre.ExactValueEvaluator;
import edu.stanford.nlp.sempre.Example;
import edu.stanford.nlp.sempre.FeatureExtractor;
import edu.stanford.nlp.sempre.FloatingParser;
import edu.stanford.nlp.sempre.Grammar;
import edu.stanford.nlp.sempre.JavaExecutor;
import edu.stanford.nlp.sempre.Params;
import edu.stanford.nlp.sempre.Parser;
import edu.stanford.nlp.sempre.ParserState;
import edu.stanford.nlp.sempre.ReinforcementParser;
import edu.stanford.nlp.sempre.Value;
import edu.stanford.nlp.sempre.test.TestUtils;
import fig.basic.LogInfo;
import java.util.HashMap;
import org.testng.AssertJUnit;
import org.testng.annotations.Test;

public class ParserTest {
    private static void checkNumDerivations(Parser parser, Params params, String utterance, String targetValue, int numExpected) {
        Parser.opts.verbose = 5;
        Example ex = TestUtils.makeSimpleExample(utterance, targetValue != null ? Value.fromString(targetValue) : null);
        ParserState state = parser.parse(params, ex, targetValue != null);
        for (Derivation deriv : state.predDerivations) {
            LogInfo.dbg(deriv.getAllFeatureVector());
            LogInfo.dbg(params.getWeights());
            LogInfo.dbgs((String)"Score %f", (Object[])new Object[]{deriv.computeScore(params)});
        }
        AssertJUnit.assertEquals((int)numExpected, (int)ex.getPredDerivations().size());
        if (numExpected > 0 && targetValue != null) {
            AssertJUnit.assertEquals((String)targetValue, (String)ex.getPredDerivations().get((int)0).value.toString());
        }
    }

    private static void checkNumDerivations(Parser parser, String utterance, String targetValue, int numExpected) {
        ParserTest.checkNumDerivations(parser, new Params(), utterance, targetValue, numExpected);
    }

    static ParseTest ABCTest() {
        return new ParseTest(TestUtils.makeAbcGrammar()){

            @Override
            public void test(Parser parser) {
                ParserTest.checkNumDerivations(parser, "a +", null, 0);
                ParserTest.checkNumDerivations(parser, "a", "(string a)", 1);
                ParserTest.checkNumDerivations(parser, "a b", "(string a,b)", 1);
                ParserTest.checkNumDerivations(parser, "a b c", "(string a,b,c)", 2);
                ParserTest.checkNumDerivations(parser, "a b c a b c", "(string a,b,c,a,b,c)", 42);
            }
        };
    }

    static ParseTest ArithmeticTest() {
        return new ParseTest(TestUtils.makeArithmeticGrammar()){

            @Override
            public void test(Parser parser) {
                ParserTest.checkNumDerivations(parser, "1 + ", null, 0);
                ParserTest.checkNumDerivations(parser, "1 plus 2", "(number 3)", 1);
                ParserTest.checkNumDerivations(parser, "2 times 3", "(number 6)", 1);
                ParserTest.checkNumDerivations(parser, "1 plus times 3", null, 0);
                ParserTest.checkNumDerivations(parser, "times", null, 0);
            }
        };
    }

    @Test
    public void checkBeamNumDerivationsForABCGrammar() {
        Parser.opts.coarsePrune = false;
        ParseTest p = ParserTest.ABCTest();
        p.test(new BeamParser(p.getParserSpec()));
        p = ParserTest.ArithmeticTest();
        p.test(new BeamParser(p.getParserSpec()));
    }

    @Test
    public void checkCoarseBeamNumDerivations() {
        Parser.opts.coarsePrune = true;
        ParseTest p = ParserTest.ABCTest();
        p.test(new BeamParser(p.getParserSpec()));
        p = ParserTest.ArithmeticTest();
        p.test(new BeamParser(p.getParserSpec()));
    }

    @Test(groups={"reinforcement"})
    public void checkReinforcementNumDerivations() {
        ParseTest p = ParserTest.ABCTest();
        p.test(new ReinforcementParser(p.getParserSpec()));
        p = ParserTest.ArithmeticTest();
        p.test(new ReinforcementParser(p.getParserSpec()));
    }

    @Test
    public void checkFloatingNumDerivations() {
        FloatingParser.opts.defaultIsFloating = false;
        ParseTest p = ParserTest.ABCTest();
        p.test(new FloatingParser(p.getParserSpec()));
        p = ParserTest.ArithmeticTest();
        p.test(new FloatingParser(p.getParserSpec()));
        FloatingParser.opts.defaultIsFloating = true;
        FloatingParser parser = new FloatingParser(ParserTest.ABCTest().getParserSpec());
        FloatingParser.opts.maxDepth = 2;
        ParserTest.checkNumDerivations(parser, "ignore", null, 3);
        FloatingParser.opts.maxDepth = 3;
        ParserTest.checkNumDerivations(parser, "ignore", null, 12);
    }

    public void checkRankingArithmetic(Parser parser) {
        Params params = new Params();
        HashMap<String, Double> features = new HashMap<String, Double>();
        features.put("rule :: $Operator -> and (ConstantFn (lambda y (lambda x (call + (var x) (var y)))))", 1.0);
        features.put("rule :: $Operator -> and (ConstantFn (lambda y (lambda x (call * (var x) (var y)))))", -1.0);
        params.update(features);
        ParserTest.checkNumDerivations(parser, params, "2 and 3", "(number 5)", 2);
        params = new Params();
        features.put("rule :: $Operator -> and (ConstantFn (lambda y (lambda x (call + (var x) (var y)))))", -1.0);
        features.put("rule :: $Operator -> and (ConstantFn (lambda y (lambda x (call * (var x) (var y)))))", 1.0);
        params.update(features);
        ParserTest.checkNumDerivations(parser, params, "2 and 3", "(number 6)", 2);
    }

    @Test
    void checkRankingSimple() {
        this.checkRankingArithmetic(new BeamParser(ParserTest.ArithmeticTest().getParserSpec()));
    }

    @Test
    void checkRankingReinforcement() {
        this.checkRankingArithmetic(new ReinforcementParser(ParserTest.ArithmeticTest().getParserSpec()));
    }

    @Test
    void checkRankingFloating() {
        FloatingParser.opts.defaultIsFloating = false;
        this.checkRankingArithmetic(new FloatingParser(ParserTest.ArithmeticTest().getParserSpec()));
    }

    public static abstract class ParseTest {
        public Grammar grammar;

        ParseTest(Grammar g) {
            this.grammar = g;
        }

        public Parser.Spec getParserSpec() {
            JavaExecutor executor = new JavaExecutor();
            FeatureExtractor extractor = new FeatureExtractor(executor);
            FeatureExtractor.opts.featureDomains.add("rule");
            ExactValueEvaluator valueEvaluator = new ExactValueEvaluator();
            return new Parser.Spec(this.grammar, extractor, executor, valueEvaluator);
        }

        public abstract void test(Parser var1);
    }
}

