/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.nlp.sempre.test;

import edu.stanford.nlp.sempre.SemType;
import edu.stanford.nlp.sempre.SemTypeHierarchy;
import fig.basic.LispTree;
import org.testng.AssertJUnit;
import org.testng.annotations.Test;

public class SemTypeTest {
    private static SemType T(String str) {
        return SemType.fromLispTree((LispTree)LispTree.proto.parseFromString(str));
    }

    private static void verifyEquals(SemType predType, SemType wantedType) {
        AssertJUnit.assertEquals((String)wantedType.toString(), (String)predType.toString());
    }

    private static void verifyMeet(String t1, String t2) {
        SemTypeTest.verifyMeet(t1, t2, t2);
    }

    private static void verifyMeet(String t1, String t2, String t) {
        SemTypeTest.verifyEquals(SemTypeTest.T(t1).meet(SemTypeTest.T(t2)), SemTypeTest.T(t));
        SemTypeTest.verifyEquals(SemTypeTest.T(t2).meet(SemTypeTest.T(t1)), SemTypeTest.T(t));
    }

    @Test
    public void simpleSemType() {
        SemTypeHierarchy.opts.failOnUnknownTypes = false;
        SemTypeTest.verifyMeet("city", "city");
        SemTypeTest.verifyMeet("city", "country", "(union)");
        SemTypeTest.verifyMeet("city", "(union city country)", "city");
        SemTypeTest.verifyMeet("(union city country river)", "(union city country)");
        SemTypeTest.verifyEquals(SemTypeTest.T("(-> city fb:type.int)").apply(SemTypeTest.T("(union city country)")), SemTypeTest.T("fb:type.int"));
        SemTypeTest.verifyEquals(SemTypeTest.T("(-> city fb:type.int fb:type.float)").apply(SemTypeTest.T("(union city country)")).apply(SemTypeTest.T("fb:type.int")), SemTypeTest.T("fb:type.float"));
        SemTypeTest.verifyEquals(SemTypeTest.T("fb:type.datetime").apply(SemTypeTest.T("fb:common.topic")), SemTypeTest.T("(union)"));
        SemTypeTest.verifyEquals(SemTypeTest.T("(-> fb:type.int fb:type.datetime)").apply(SemTypeTest.T("fb:type.number")), SemTypeTest.T("fb:type.datetime"));
        SemTypeTest.verifyEquals(SemTypeTest.T("(-> fb:type.number fb:type.datetime)").apply(SemTypeTest.T("fb:type.int")), SemTypeTest.T("fb:type.datetime"));
        SemTypeTest.verifyMeet("(-> fb:location.location fb:type.number)", "(-> fb:location.location fb:type.float)");
        SemTypeTest.verifyMeet("fb:common.topic", "fb:location.location");
        SemTypeTest.verifyMeet("fb:type.any", "fb:type.boolean");
        SemTypeTest.verifyMeet("fb:type.any", "fb:type.number");
        SemTypeTest.verifyMeet("fb:type.any", "fb:type.datetime");
        SemTypeTest.verifyMeet("fb:type.any", "fb:type.cvt");
        SemTypeTest.verifyMeet("fb:type.any", "fb:type.text");
        SemTypeTest.verifyMeet("fb:type.any", "fb:location.location");
        SemTypeTest.verifyMeet("fb:type.any", "fb:common.topic");
        SemTypeTest.verifyMeet("fb:common.topic", "fb:common.topic");
        SemTypeTest.verifyMeet("top", "(-> t t)");
        SemTypeTest.verifyMeet("top", "fb:type.datetime");
        SemTypeTest.verifyMeet("top", "(union a b)");
        SemTypeTest.verifyMeet("(-> (-> a b) top)", "(-> top (-> a b))", "(-> (-> a b) (-> a b))");
        SemTypeTest.verifyMeet("(-> (union city country) person)", "(-> city (union person dog))", "(-> city person)");
    }

    public static void main(String[] args) {
        new SemTypeTest().simpleSemType();
    }
}

