/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.nlp.sempre.test;

import edu.stanford.nlp.sempre.ConcatFn;
import edu.stanford.nlp.sempre.ConstantFn;
import edu.stanford.nlp.sempre.Derivation;
import edu.stanford.nlp.sempre.DerivationStream;
import edu.stanford.nlp.sempre.Example;
import edu.stanford.nlp.sempre.FilterPosTagFn;
import edu.stanford.nlp.sempre.FilterSpanLengthFn;
import edu.stanford.nlp.sempre.Formula;
import edu.stanford.nlp.sempre.LanguageAnalyzer;
import edu.stanford.nlp.sempre.Rule;
import edu.stanford.nlp.sempre.SemanticFn;
import edu.stanford.nlp.sempre.SimpleAnalyzer;
import edu.stanford.nlp.sempre.test.TestUtils;
import fig.basic.LispTree;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.testng.AssertJUnit;
import org.testng.annotations.Test;

public class SemanticFnTest {
    private static Formula F(String s) {
        return Formula.fromString(s);
    }

    void check(Formula target, DerivationStream derivations) {
        if (!derivations.hasNext()) {
            throw new RuntimeException("Expected 1 derivation, got " + derivations);
        }
        AssertJUnit.assertEquals((Object)target, (Object)((Derivation)derivations.next()).formula);
    }

    void check(Formula target, String utterance, SemanticFn fn, List<Derivation> children) {
        Example ex = TestUtils.makeSimpleExample(utterance);
        this.check(target, fn.call(ex, new SemanticFn.CallInfo(null, 0, ex.numTokens(), Rule.nullRule, children)));
    }

    void check(Formula target, String utterance, SemanticFn fn) {
        List<Derivation> empty = Collections.emptyList();
        this.check(target, utterance, fn, empty);
    }

    void checkNumDerivations(DerivationStream derivations, int num) {
        AssertJUnit.assertEquals((int)num, (int)derivations.estimatedSize());
    }

    @Test
    public void constantFn() {
        LanguageAnalyzer.setSingleton(new SimpleAnalyzer());
        this.check(SemanticFnTest.F("(number 3)"), "whatever", new ConstantFn(SemanticFnTest.F("(number 3)")));
    }

    Derivation D(Formula f) {
        return new Derivation.Builder().formula(f).prob(1.0).createDerivation();
    }

    LispTree T(String str) {
        return (LispTree)LispTree.proto.parseFromString(str);
    }

    @Test
    public void concatFn() {
        LanguageAnalyzer.setSingleton(new SimpleAnalyzer());
        this.check(SemanticFnTest.F("(string \"a b\")"), "a b", new ConcatFn(" "), Arrays.asList(this.D(SemanticFnTest.F("(string a)")), this.D(SemanticFnTest.F("(string b)"))));
    }

    @Test
    public void filterPosTagFn() {
        LanguageAnalyzer.setSingleton(new SimpleAnalyzer());
        FilterPosTagFn filter = new FilterPosTagFn();
        filter.init(this.T("(FilterPosTagFn token NNP)"));
        Derivation child = new Derivation.Builder().createDerivation();
        Example ex = TestUtils.makeSimpleExample("where is Obama");
        AssertJUnit.assertEquals((boolean)filter.call(ex, new SemanticFn.CallInfo(null, 0, 1, Rule.nullRule, Collections.singletonList(child))).hasNext(), (boolean)false);
        AssertJUnit.assertEquals((boolean)filter.call(ex, new SemanticFn.CallInfo(null, 1, 2, Rule.nullRule, Collections.singletonList(child))).hasNext(), (boolean)false);
        AssertJUnit.assertEquals((boolean)filter.call(ex, new SemanticFn.CallInfo(null, 2, 3, Rule.nullRule, Collections.singletonList(child))).hasNext(), (boolean)true);
    }

    @Test
    public void filterSpanLengthFn() {
        LanguageAnalyzer.setSingleton(new SimpleAnalyzer());
        FilterSpanLengthFn filter = new FilterSpanLengthFn();
        filter.init(this.T("(FilterSpanLengthFn 2)"));
        Derivation child = new Derivation.Builder().createDerivation();
        Example ex = TestUtils.makeSimpleExample("This is a sentence with some words");
        AssertJUnit.assertEquals((boolean)filter.call(ex, new SemanticFn.CallInfo(null, 0, 1, Rule.nullRule, Collections.singletonList(child))).hasNext(), (boolean)false);
        AssertJUnit.assertEquals((boolean)filter.call(ex, new SemanticFn.CallInfo(null, 0, 2, Rule.nullRule, Collections.singletonList(child))).hasNext(), (boolean)true);
        AssertJUnit.assertEquals((boolean)filter.call(ex, new SemanticFn.CallInfo(null, 0, 2, Rule.nullRule, Collections.singletonList(child))).hasNext(), (boolean)true);
        filter = new FilterSpanLengthFn();
        filter.init(this.T("(FilterSpanLengthFn 2 4)"));
        AssertJUnit.assertEquals((boolean)filter.call(ex, new SemanticFn.CallInfo(null, 0, 1, Rule.nullRule, Collections.singletonList(child))).hasNext(), (boolean)false);
        AssertJUnit.assertEquals((boolean)filter.call(ex, new SemanticFn.CallInfo(null, 0, 2, Rule.nullRule, Collections.singletonList(child))).hasNext(), (boolean)true);
        AssertJUnit.assertEquals((boolean)filter.call(ex, new SemanticFn.CallInfo(null, 0, 3, Rule.nullRule, Collections.singletonList(child))).hasNext(), (boolean)true);
        AssertJUnit.assertEquals((boolean)filter.call(ex, new SemanticFn.CallInfo(null, 0, 4, Rule.nullRule, Collections.singletonList(child))).hasNext(), (boolean)true);
        AssertJUnit.assertEquals((boolean)filter.call(ex, new SemanticFn.CallInfo(null, 0, 5, Rule.nullRule, Collections.singletonList(child))).hasNext(), (boolean)false);
    }
}

