/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.nlp.sempre.test;

import com.google.common.collect.Iterables;
import com.google.common.collect.Maps;
import edu.stanford.nlp.sempre.Builder;
import edu.stanford.nlp.sempre.Dataset;
import edu.stanford.nlp.sempre.FeatureExtractor;
import edu.stanford.nlp.sempre.FormulaMatchExecutor;
import edu.stanford.nlp.sempre.Grammar;
import edu.stanford.nlp.sempre.LanguageAnalyzer;
import edu.stanford.nlp.sempre.Learner;
import edu.stanford.nlp.sempre.SimpleAnalyzer;
import fig.basic.Evaluation;
import fig.basic.Pair;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.testng.AssertJUnit;
import org.testng.annotations.Test;

public class SystemSanityTest {
    private static Builder makeBuilder(String grammarPath) {
        Grammar g = new Grammar();
        g.read(grammarPath);
        Builder b = new Builder();
        b.grammar = g;
        b.executor = new FormulaMatchExecutor();
        b.buildUnspecified();
        return b;
    }

    private static Dataset makeDataset() {
        Dataset d = new Dataset();
        d.readFromPathPairs(Collections.singletonList(Pair.newPair((Object)"train", (Object)"freebase/data/unittest-learn.examples")));
        return d;
    }

    private static Map<String, List<Evaluation>> learn(Builder builder, Dataset dataset) {
        HashMap evals = Maps.newHashMap();
        new Learner(builder.parser, builder.params, dataset).learn(3, evals);
        return evals;
    }

    @Test(groups={"sparql", "corenlp"})
    public void easyEndToEnd() {
        String[] grammarPaths;
        LanguageAnalyzer.setSingleton(new SimpleAnalyzer());
        Dataset dataset = SystemSanityTest.makeDataset();
        for (String grammarPath : grammarPaths = new String[]{"freebase/data/unittest-learn.grammar", "freebase/data/unittest-learn-ccg.grammar"}) {
            Builder builder = SystemSanityTest.makeBuilder(grammarPath);
            FeatureExtractor.opts.featureDomains.add("rule");
            Map<String, List<Evaluation>> evals = SystemSanityTest.learn(builder, dataset);
            AssertJUnit.assertEquals((Object)1.0, (Object)((Evaluation)Iterables.getLast((Iterable)evals.get("train"))).getFig("correct").min());
        }
    }
}

