/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.nlp.sempre.test;

import edu.stanford.nlp.sempre.Formula;
import edu.stanford.nlp.sempre.SemType;
import edu.stanford.nlp.sempre.TypeInference;
import edu.stanford.nlp.sempre.TypeLookup;
import org.testng.AssertJUnit;
import org.testng.annotations.Test;

public class TypeInferenceTest {
    private static final CustomTypeLookup typeLookup = new CustomTypeLookup();

    private static Formula F(String str) {
        return Formula.fromString(str);
    }

    private static SemType T(String str) {
        return SemType.fromString(str);
    }

    private static SemType FT(String str) {
        return TypeInference.inferType(TypeInferenceTest.F(str), typeLookup);
    }

    void check(String fstr, String tstr) {
        System.out.println("check " + fstr + " " + tstr);
        AssertJUnit.assertEquals((String)TypeInferenceTest.T(tstr).toString(), (String)TypeInferenceTest.FT(fstr).toString());
    }

    @Test
    public void simpleSemType() {
        this.check("(fb:location.location.area (>= (number 200)))", "fb:location.location");
        this.check("(number 3)", "fb:type.number");
        this.check("(string foo)", "fb:type.text");
        this.check("(date 1981 1 1)", "fb:type.datetime");
        this.check("fb:en.barack_obama", "fb:common.topic");
        this.check("fb:people.person.place_of_birth", "(-> fb:location.location fb:people.person)");
        this.check("(fb:type.object.type fb:location.location)", "fb:location.location");
        this.check("(fb:people.person.place_of_birth (fb:type.object.type fb:location.location))", "fb:people.person");
        this.check("(!fb:people.person.place_of_birth (fb:type.object.type fb:location.location))", "(union)");
        this.check("(and (fb:type.object.type fb:common.topic) (fb:people.person.place_of_birth fb:en.seattle))", "fb:people.person");
        this.check("(and (fb:type.object.type fb:location.location) (fb:people.person.place_of_birth fb:en.seattle))", "(union)");
        this.check("(mark x (fb:people.person.parents (var x)))", "fb:people.person");
        this.check("(mark x (fb:people.person.place_of_birth (var x)))", "(union)");
        this.check("(lambda x (fb:people.person.place_of_birth (var x)))", "(-> fb:location.location fb:people.person)");
        this.check("(lambda x (!fb:people.person.place_of_birth (var x)))", "(-> fb:people.person fb:location.location)");
        this.check("(lambda x (fb:people.person.place_of_birth (var x)))", "(-> fb:location.location fb:people.person)");
        this.check("(lambda x (!fb:people.person.place_of_birth (var x)))", "(-> fb:people.person fb:location.location)");
        this.check("(lambda x (!fb:people.person.profession (fb:people.person.place_of_birth (var x))))", "(-> fb:location.location fb:people.profession)");
        this.check("(lambda b ((var b) (fb:type.object.type fb:people.person)))", "(-> (-> fb:people.person top) top)");
        this.check("(lambda b (and (fb:type.object.type fb:location.location) ((var b) (fb:type.object.type fb:people.person))))", "(-> (-> fb:people.person fb:location.location) fb:location.location)");
        this.check("(lambda x (lambda y ((var x) (var y))))", "(-> (-> top top) (-> top top))");
        this.check("(lambda x (lambda x (fb:people.person.place_of_birth (var x))))", "(-> top (-> fb:location.location fb:people.person))");
        this.check("(lambda x (not (var x)))", "(-> fb:type.any fb:type.any)");
        this.check("(lambda x (count (var x)))", "(-> fb:type.any fb:type.number)");
        this.check("(lambda x (count (fb:people.person.place_of_birth (var x))))", "(-> fb:location.location fb:type.number)");
        this.check("(+ (number 3) (number 4))", "fb:type.number");
        this.check("(+ (date 1981 1 1) (string 4))", "(union)");
        this.check("(- (date 1982 1 1) (date 1981 1 1))", "fb:type.datetime");
        this.check("(reverse fb:people.person.place_of_birth)", "(-> fb:people.person fb:location.location)");
        this.check("(argmax 1 1 (fb:type.object.type fb:people.person) fb:people.person.date_of_birth)", "fb:people.person");
        this.check("(argmax 1 1 (fb:type.object.type fb:common.topic) fb:people.person.date_of_birth)", "fb:people.person");
        this.check("(argmax 1 1 (fb:type.object.type fb:common.topic) (reverse (lambda x (number 3))))", "fb:common.topic");
        this.check("(lambda x (lambda y (argmax 1 1 (var x) (var y))))", "(-> fb:type.any (-> (-> (union fb:type.number fb:type.datetime) fb:type.any) fb:type.any))");
        this.check("(call Math.cos (number 0))", "fb:type.float");
        this.check("(call Math.cos (string abc))", "(union)");
        this.check("(lambda x (lambda y (call .concat (var x) (var y))))", "(-> fb:type.text (-> fb:type.text fb:type.text))");
        this.check("(lambda x (call .length (var x)))", "(-> fb:type.text fb:type.int)");
    }

    public static void main(String[] args) {
        new TypeInferenceTest().simpleSemType();
    }

    static class CustomTypeLookup
    implements TypeLookup {
        CustomTypeLookup() {
        }

        @Override
        public SemType getEntityType(String entity) {
            return null;
        }

        @Override
        public SemType getPropertyType(String property) {
            switch (property) {
                case "fb:location.location.area": {
                    return TypeInferenceTest.T("(-> fb:type.number fb:location.location)");
                }
                case "fb:people.person.date_of_birth": {
                    return TypeInferenceTest.T("(-> fb:type.datetime fb:people.person)");
                }
                case "fb:people.person.parents": {
                    return TypeInferenceTest.T("(-> fb:people.person fb:people.person)");
                }
                case "fb:people.person.place_of_birth": {
                    return TypeInferenceTest.T("(-> fb:location.location fb:people.person)");
                }
                case "fb:people.person.profession": {
                    return TypeInferenceTest.T("(-> fb:people.profession fb:people.person)");
                }
            }
            return null;
        }
    }
}

