#!/bin/bash
set -e

model_type=${1}
model_name0=$(basename $2)
split=$3
order=${4:-dfs}
test_file="data/streg/${split}.bin"
max_decode_step=70
smooth='none'
smooth_alpha=0
model_name="${model_name0}"
decode_file="outputs/synth.decode.${model_name}.${split}.${order}.txt"
report_file="outputs/synth.report.${model_name}.${split}.${order}.txt"
eval_file="outputs/synth.eval.${model_name}.${split}.${order}.pkl"
cache_file="misc/cache.pkl"

python -u synthesize.py \
    --model_name ${model_type} \
    --test_file ${test_file} \
    --model_file $2 \
    --search_order ${order} \
    --report_file ${report_file} \
    --decode_file ${decode_file} \
    --cache_file ${cache_file} \
    --eval_file ${eval_file} \
    --smooth ${smooth} \
    --smooth_alpha ${smooth_alpha} \
    --max_decode_step 70 2>&1 | tee -a logs/test.${model_name}.${split}.log
