#!/bin/bash
set -e
model_type=${1}
model_name=$(basename $2)
split=$3
order=${4:-dfs}

test_file="data/streg/${split}.bin"
max_decode_step=70
beam_size=20
decode_file="outputs/synth.decode.${model_name}.b${beam_size}.${split}.${order}.bin"
report_file="outputs/synth.report.${model_name}.${split}.${order}.txt"
eval_file="outputs/synth.eval.${model_name}.${split}.${order}.pkl"
cache_file="misc/cache.pkl"

python -u test_joint.py \
    --model_name ${model_type} \
    --test_file ${test_file} \
    --model_file $2 \
    --beam_size ${beam_size} \
    --search_order ${order} \
    --report_file ${report_file} \
    --decode_file ${decode_file} \
    --cache_file ${cache_file} \
    --eval_file ${eval_file} \
    --max_decode_step 70 2>&1 | tee -a logs/test.${model_name}.${split}.log
