# Optimal Neural Synthesis from Multimodal Specifications

**Requirements**

* pytorch 1.4.0
* Jave JDK 1.8
* z3

## Results

The perfomance of our models can be reproduced with the code.

<table>
  <tr>
    <td>Approach</td>
    <td colspan='2'>Test</td>
     <td colspan='2'>Test-E</td>
  </tr>
  <tr>
    <td>ASN+P</td>
    <td>58.0</td>
    <td>1.3<sub>10<sup>3</sup></sub></td>
    <td>45.8</td>
    <td>1.4<sub>10<sup>3</sup></sub></td>
  </tr>
    <tr>
    <td>ASN-P</td>
    <td>55.3</td>
    <td>-</td>
    <td>43.1</td>
    <td>-</td>
  </tr>
    <tr>
    <td>OpSynth</td>
    <td>59.8</td>
    <td>5.6<sub>10<sup>2</sup></sub></td>
    <td>46.9</td>
    <td>8.1<sub>10<sup>2</sup></sub></td>
  </tr>
      <tr>
    <td>OpSynth+R</td>
    <td>58.0</td>
    <td>5.7<sub>10<sup>2</sup></sub></td>
    <td>44.1</td>
    <td>8.2<sub>10<sup>2</sup></sub></td>
  </tr>
</table>




## Train

We have provided pretrained model in `checkpoints/streg`, including

* *ASN* based neural model: `checkpoints/streg/pretrained.asn.bin`
* *ASN* based neural model extended with *RobustFill*: `checkpoints/streg/pretrained.asn.rob.bin`



Chekpoints are ready to use. To retrain models from scratch, please use folloing command.

Train *ASN*:

`./scripts/streg/train.sh`


Train *ASN* extended with *RobustFill*:

`./scripts/streg/train_joint.sh`

## Test
Run *ASN+P* (*ASN* + beam search + pruning): 

`./scripts/streg/run_beam.sh`


Run *OpSynth-P* (optimal synthesis without pruning):

`./scripts/streg/run_noprune.sh`


Run *OpSynth* (optimal synthesis):

`./scripts/streg/run_synth.sh`


Run *OpSynth+R* (optimal synthesis extended with *RobustFill*):

`./scripts/streg/run_synth_rob.sh`
