# DIFFSSR: Stereo Image Super-resolution Using Differential Transformer

## Acknowledgement
This project is mainly based on [SwinFIR](https://github.com/Zdafeng/SwinFIR).

## Environment
- [PyTorch >= 1.7](https://pytorch.org/)
- [BasicSR == 1.3.5](https://github.com/XPixelGroup/BasicSR/blob/master/INSTALL.md) 


### Installation
Install Pytorch first.
Then,
```
pip install -r requirements.txt
python setup.py develop
```


## How To Train
- Refer to `./options/train` for the configuration file of the model to train.
- Preparation of training data can refer to [NAFSSR](https://github.com/megvii-research/NAFNet/blob/main/docs/StereoSR.md). 
- The training command is like
```
CUDA_VISIBLE_DEVICES=0,1,2,3,4,5,6,7 python -m torch.distributed.launch --nproc_per_node=8 --master_port=4321 swinfir/train.py -opt options/train/DIFFSSR/train_DIFFSSR_SSRx2_scratch.yml --launcher pytorch
```

The training logs and weights will be saved in the `./experiments` folder.


## How To Test

**DIFFSSR for stereo image super resolution**
**Stereo Image Super Resolution**
- Prepare the testing data according to [NAFSSR](https://github.com/megvii-research/NAFNet/blob/main/docs/StereoSR.md) for stereo image super resolution.
- Then run the follwing codes (taking `DIFFSSRSSR_SSRx4.yml` as an example):
```
python swinfir/test.py -opt options/test/DIFFSSR/DIFFSSR_SSRx4.yml
```


## How To Inference
**Stereo Image Super Resolution**
``` 
python inference/inference_swinfirssr.py
```

