using Laplacians, LinearAlgebra, Graphs, SimpleWeightedGraphs

function ge(G, o)
   solver = cgLapSolver(G);
   x = solver(o);
   return sqrt(dot(o', x));
end

open("fig_5a.csv", "w") do f
   write(f, "nodes\trun\n")
   for n in [500, 1000, 2000, 5000, 10000, 20000, 50000, 100000, 200000, 500000, 1000000, 2000000]
      for r in 0:10
         write(stderr, "$(n)\t$(r)\n");
         k = trunc(Int, n / 4);
         G = adjacency_matrix(SimpleWeightedGraph(stochastic_block_model(reshape([k1 == k2 ? 3.12 : 0.3 for k2 in 1:4 for k1 in 1:4], (4, 4)), [k, k, k, k])));
         s = rand(Float64, n);
         t = rand(Float64, n);
         trial = @timed ge(G, s - t);
         if r != 0
            write(f, "$(n)\t$(trial.time)\n");
            flush(f);
         end
      end
   end
end

n = 50000;

open("fig_5b.csv", "w") do f
   write(f, "edges\trun\n")
   for avgdeg in [10, 20, 50, 100, 200, 500, 1000, 2000, 5000]
      for r in 0:10
         write(stderr, "$(avgdeg)\t$(r)\n");
         k = trunc(Int, n / 4);
         G = adjacency_matrix(SimpleWeightedGraph(stochastic_block_model(reshape([k1 == k2 ? avgdeg * 1.5 : avgdeg / 6 for k2 in 1:4 for k1 in 1:4], (4, 4)), [k, k, k, k])));
         s = rand(Float64, n);
         t = rand(Float64, n);
         trial = @timed ge(G, s - t);
         if r != 0
            write(f, "$(avgdeg)\t$(trial.time)\n");
            flush(f);
         end
      end
   end
end
