# -*- coding: utf-8 -*-
"""Environment.ipynb
"""
import numpy as np 
#################################Env Class##############################################
class Env:
    def __init__(self, feature, num_states, theta, gamma, reward_var, cost_var):
        self.num_states = num_states
        self.feature = feature
        self.reward_weights = theta  # True weights for generating rewards
        self.cost_weights = gamma
        self.reward_var = reward_var
        self.cost_var = cost_var


    def get_state(self):
        """Return random features as an example."""
        self.state = 1
        return self.state

    def take_action(self, action):
        """Generate reward based on the action and true weights."""
        reward = self.reward_weights @ self.feature.transform(self.state, action)
        cost   = self.cost_weights @ self.feature.transform(self.state, action)
        reward_noisy = reward + np.random.normal(0, np.sqrt(self.reward_var))
        cost_noisy  = cost + np.random.normal(0, np.sqrt(self.cost_var))
        return reward_noisy, cost_noisy, reward, cost