import os
from os.path import join
from os import listdir
import pickle


def write_list(base_path):
    metadata = []
    metadata_classwise = {}

    for cls in listdir(base_path):
        metadata_classwise[cls] = []
        for image in listdir(join(base_path, cls)):
            image_path = os.path.abspath(join(base_path, cls, image))
            metadata_classwise[cls].append(image_path)
            # image_path_class = image_path + "_" + cls
            metadata.append(image_path)
    file_name = os.path.join('/data/wujingrong', "CompleteDataset.pkl")
    with open(file_name, 'wb') as f:
        pickle.dump(metadata, f)
    file_name = os.path.join('/data/wujingrong', "CompleteDatset_classwise.pkl")
    with open(file_name, 'wb') as f:
        pickle.dump(metadata_classwise, f)


if __name__ == '__main__':
    base_path = '/data/wujingrong/Complete_Classification_Dataset'
    # write_list(base_path)
    with open(os.path.join('../data/data_files', "oracle.pkl"), 'rb') as f:
        meta_data = pickle.load(f)
    print(len(meta_data))
