import sys
import argparse
from relative_tester import RelativeTester
from utils import init_random_seeds, config, get_device
import json
from tqdm import tqdm

if __name__ == "__main__":
    init_random_seeds()
    parser = argparse.ArgumentParser(description="R-Detect the file content")
    parser.add_argument(
        "--test_file",
        type=str,
        help="The file path of the test file. Default is demo_text_gpt.txt",
        default="./demo_text_gpt.txt",
    )
    parser.add_argument(
        "--use_gpu",
        action="store_true",
        help="Use GPU or not.",
    )
    parser.add_argument(
        "--local_model",
        type=str,
        help="Use local model or not, you need to download the model first, and set the path. Script will use remote if this param is empty.",
        default="",
    )
    parser.add_argument(
        "--feature_ref_HWT",
        type=str,
        help="The feature ref path of HWT. Script will use remote if this param is empty.",
        default="",
    )
    parser.add_argument(
        "--feature_ref_MGT",
        type=str,
        help="The feature ref path of MGT. Default is Empty",
        default="",
    )
    args = parser.parse_args()
    config["test_file"] = args.test_file
    config["use_gpu"] = args.use_gpu
    config["local_model"] = args.local_model
    config["feature_ref_HWT"] = args.feature_ref_HWT
    config["feature_ref_MGT"] = args.feature_ref_MGT
    print(f"Running on device", get_device())
    relative_tester = RelativeTester()
    for model_name in ["DetectRL_multillm", "DetectRL_multidomain"]:
    #     for attack_type in ["insert", "delete", "replace", "dipper"]:
        human_json = f"./AIDetection/Related_dataset/DetectRL/{model_name}_human_test.json"
        machine_json = f"./AIDetection/Related_dataset/DetectRL/{model_name}_machine_test.json"
        with open(human_json, "r", encoding="utf-8") as f:
            human_text = json.load(f).get("human_text", [])
        with open(machine_json, "r", encoding="utf-8") as f:
            machine_text = json.load(f).get("machine_text", [])


        human_scores = [relative_tester.test(text) for text in tqdm(human_text)]
        machine_scores = [relative_tester.test(text) for text in tqdm(machine_text)]

        human_out_path = f"./AIDetection/DNA-DetectLLM/scores/{model_name}_RDetect_human_test.json"
        machine_out_path = f'./AIDetection/DNA-DetectLLM/scores/{model_name}_RDetect_machine_test.json'

        with open(human_out_path, "w", encoding="utf-8") as f:
            json.dump({"predictions": human_scores}, f, ensure_ascii=False, indent=2)

        with open(machine_out_path, "w", encoding="utf-8") as f:
            json.dump({"predictions": machine_scores}, f, ensure_ascii=False, indent=2)
        # with open(config["test_file"], "r") as file:
        #     content = file.read()
        #     print(relative_tester.test(content))
        # print(content)
