#!/bin/bash

STRAGGLAR=(1060864 4214784 16801792 67121152 268455936 1073766400 2147504128 4294979584)
NUM_ITERS=50
OUTPUT_FILE="../data/rs_profiling.csv"
BINARY="../code/reducescatter"

# Initialize the output file with the CSV header
echo "buffer_size_bytes,iteration,runtime_ms,bw_gbs" > "$OUTPUT_FILE"

# Run the binary for each buffer size and directly append all output
for extra in "${STRAGGLAR[@]}"; do
    echo "Running for buffer size $extra..."
    "$BINARY" "$extra" "$NUM_ITERS" >> "$OUTPUT_FILE"
done
