#!/bin/bash

LATENCIES=(0 5 10 15 20 25 30 35 40) # (0 2 4 6 8 10 12 14 16 18 20) 

ALGORITHMS=("ring" "rhd" "stragglar" "direct")
NUM_ITERS=50
BUFFER_SIZE=4294967296
BUFFER_SIZE_stragglar=4294979584
OUTPUT_FILE="../data/8gpu_delay_4GiB.csv"
BINARY="../code/allreduce"

echo "algorithm,buffer_size_bytes,iteration,delay,runtime_ms,bw_gbs" > "$OUTPUT_FILE"

for alg in "${ALGORITHMS[@]}"; do
  for idx in "${!LATENCIES[@]}"; do
    amt=${LATENCIES[idx]}

    echo "Running $alg for delay $amt ms ..."

    if [[ $alg == "stragglar" ]]; then
      # pass the extra arg only for stragglar
      "$BINARY" "$BUFFER_SIZE_stragglar" "$alg" "$NUM_ITERS" "$amt"
    else
      "$BINARY" "$BUFFER_SIZE" "$alg" "$NUM_ITERS" "$amt"
    fi | grep -E '^[a-z]+,[0-9]+,[0-9]+,[0-9]+\.[0-9]+,[0-9]+\.[0-9]+,[0-9]+\.[0-9]+$' >> "$OUTPUT_FILE"
  done
done