import os, json


def load_jsonl(file_path):
    data = []
    with open(file_path, "r", encoding="utf-8") as file:
        for line in file:
            data.append(json.loads(line.strip()))
    return data

def save_jsonl(data, file_path):
    with open(file_path, "w", encoding="utf-8") as file:
        for entry in data:
            file.write(json.dumps(entry) + "\n")
            
            
def postprocess(result_jsonl, save_path):
    observation_json = {}
    for idx, content in enumerate(result_jsonl):
        info = {}
        info['status'] = content['status']
        info['exec_res'] = content['execution_result']
        info['error'] = content['error_message']
        observation_json[idx] = info
    json.dump(observation_json, open(save_path, 'w'), indent=4)
