initial_prompt = """Interact with the "{db_id}" database using postgre SQL to solve the user issue. You will be given the following information:
1. Database schema: complete CREATE TABLE … DDL.
2. User Issue: a natural language description of the desired outcome or the current bug.
3. Problematic SQL: the query (or queries) that presently fails to meet the requirement.

Use interleaving Thought, Action, Observation steps. 
Thought can reason about the possible errors or other information you think you need for debugging about the current situation. For instance, it could be 1) diagnosis of the bug you see in the current query, or 2) Hypotheses you want to confirm (e.g., Maybe the join is missing a date filter). 3) Reasoning that led you to the next SQL step (checking row counts, inspecting NULLs, etc.) 4) A brief plan for what you will try next.
Action can only be the executable postgre SQL. The observartion would be the exectuation results feedback from the environment. 
Wrap your thought in the <thought>[Your Thought]</thought> tag and your action in <action>[Executable SQL]</action>


Here is an one-shot example.
\"\"\"
### Database Schema
...

### User Issue
Verify that the spent amount recorded in each row of budget matches the sum of cost for all approved expenses linked to that budget. List every budget_id where the two totals differ.

### Problematic SQL
sql_list = [ 'SELECT b.event_status, SUM(e.cost) AS total_cost, b.amount FROM   budget b JOIN   expense e\nON b.link_to_event = e.link_to_budget\nGROUP  BY b.event_status, b.amount\nHAVING SUM(e.cost) > b.amount;']

### React
<thought>
The join uses b.link_to_event, but expenses reference budgets by link_to_budget.  I will run the faulty query unchanged to confirm it
returns no rows.
</thought>

<action>
SELECT b.event_status, SUM(e.cost) AS total_cost, b.amount
FROM   budget b
JOIN   expense e
       ON b.link_to_event = e.link_to_budget
WHERE  e.approved = TRUE
GROUP  BY b.event_status, b.amount
HAVING SUM(e.cost) > b.amount;
</action>

<observation>
error_flag: False
exec_results: []
</observation>

<thought>
Empty result suggests the join key is wrong.  Join on b.budget_id
instead, then compare total_cost to b.amount again.
</thought>

<action>
SELECT b.budget_id,
       SUM(e.cost) AS total_cost,
       b.amount
FROM   budget b
JOIN   expense e
       ON b.budget_id = e.link_to_budget
WHERE  e.approved = TRUE
GROUP  BY b.budget_id, b.amount
HAVING SUM(e.cost) > b.amount;
</action>

<observation>
error_flag: False
exec_results: [
  ('rec1bG6HSft7XIvTP', 135.50, 121.14),
  ('rec1z6ISJU2HdIsVm',  19.99,  20.20)
]
</observation>

<thought>
The corrected query now lists budgets whose approved expenses exceed
their allocated amount.  Issue resolved.
</thought>

<action>[DONE]</action>
\"\"\"


The input for you is as follows:
### Database Schema
{schema}

### User Issue
{user_issue}

### Problematic SQL
sql_list = {issue_sql}

Your input must follows the following rules:
1. MOST IMPORTANT: Wrap your thought in the <thought>[Your Thought]</thought> tag and your action in <action>[Executable SQL]</action>
2. The action inside the <action></action> tags must be pure PostgreSQL statements that can be executed directly, without any comments or needs for additional post-processing.

Now generate the first thought and action for the input. 
### React
<thought>
"""


intermidate_prompt = """Interact with the "{db_id}" database using postgre SQL to solve the user issue. You will be given the following information:
1. Database schema: complete CREATE TABLE … DDL.
2. User Issue: a natural language description of the desired outcome or the current bug.
3. Problematic SQL: the query (or queries) that presently fails to meet the requirement.

Use interleaving Thought, Action, Observation steps. 
Thought can reason about the possible errors or other information you think you need for debugging about the current situation. For instance, it could be 1) diagnosis of the bug you see in the current query, or 2) Hypotheses you want to confirm (e.g., Maybe the join is missing a date filter). 3) Reasoning that led you to the next SQL step (checking row counts, inspecting NULLs, etc.) 4) A brief plan for what you will try next.
Action can only be the executable postgre SQL. The observartion would be the exectuation results feedback from the environment. 
Wrap your thought in the <thought>[Your Thought]</thought> tag and your action in <action>[Executable SQL]</action>


Here is an one-shot example.
\"\"\"
### Database Schema
...

### User Issue
Verify that the spent amount recorded in each row of budget matches the sum of cost for all approved expenses linked to that budget. List every budget_id where the two totals differ.

### Problematic SQL
sql_list = [ 'SELECT b.event_status, SUM(e.cost) AS total_cost, b.amount FROM   budget b JOIN   expense e\nON b.link_to_event = e.link_to_budget\nGROUP  BY b.event_status, b.amount\nHAVING SUM(e.cost) > b.amount;']

### React
<thought>
The join uses b.link_to_event, but expenses reference budgets by link_to_budget.  I will run the faulty query unchanged to confirm it
returns no rows.
</thought>

<action>
SELECT b.event_status, SUM(e.cost) AS total_cost, b.amount
FROM   budget b
JOIN   expense e
       ON b.link_to_event = e.link_to_budget
WHERE  e.approved = TRUE
GROUP  BY b.event_status, b.amount
HAVING SUM(e.cost) > b.amount;
</action>

<observation>
error_flag: False
exec_results: []
</observation>

<thought>
Empty result suggests the join key is wrong.  Join on b.budget_id
instead, then compare total_cost to b.amount again.
</thought>

<action>
SELECT b.budget_id,
       SUM(e.cost) AS total_cost,
       b.amount
FROM   budget b
JOIN   expense e
       ON b.budget_id = e.link_to_budget
WHERE  e.approved = TRUE
GROUP  BY b.budget_id, b.amount
HAVING SUM(e.cost) > b.amount;
</action>

<observation>
error_flag: False
exec_results:
   budget_id            total_cost  amount
0  rec1bG6HSft7XIvTP        135.50   121.14
1  rec1z6ISJU2HdIsVm         19.99    20.20
</observation>

<thought>
The corrected query now lists budgets whose approved expenses exceed
their allocated amount.  Issue resolved.
</thought>

<action>[DONE]</action>
\"\"\"

I will now provide the database schema, the user's issue, the problematic SQL query, and the (thought / action / observation) tuples from the previous rounds.
### Database Schema
{schema}

### User Issue
{user_issue}

### Problematic SQL
sql_list = {issue_sql}

Your input must follows the following rules:
1. MOST IMPORTANT: Wrap your thought in the <thought>[Your Thought]</thought> tag and your action in <action>[Executable SQL]</action>
2. The action inside the <action></action> tags must be pure PostgreSQL statements that can be executed directly without additional post-processing. DO NOT write comment in the SQL queries.
3. If you are convinced that the action from the previous round already is the final postgre SQL that solves the user's issue, then use [Done] as the sole action content of the <action> tag for this round.

Please continue from the reaction-thought chain of the previous rounds and provide the next set of <thought> and <action> sections.
### React
{history}

<thought>
"""

final_prompt = """You are a text-to-SQL expert. You will be given the following information:
1. Database schema: complete CREATE TABLE … DDL.
2. User Issue: a natural language description of the desired outcome or the current bug.
3. Problematic SQL: the query (or queries) that presently fails to meet the requirement.
4. React Thought Chain: A history of your prior debugging iterations, formatted as a sequence of thought → action → observation tuples. Each tuple is separated from the next by a blank line (\\n\\n).
	•	Thought - Your reasoning: hypotheses about errors, assumptions, or additional data requirements.
	•	Action - A pure PostgreSQL statement executed to test or correct the issue.
	•	Observation - The execution result returned by the database engine.
 
Your task is to understand all these contents and generate the final Postgre SQL that could accurately solve the user issue.

The input is as follows:
### Database Schema
{schema}

### User Issue
{user_issue}

### Problematic SQL
sql_list = {issue_sql}

### React Thought Chain
{history}

Now generate the final Postgre SQL that could accurately solve the user issue and could be directly executed. Wrap you answer in the ```sql\\n[Your Answer]``` tag. Do not give me extra explanations or comments.
```sql
"""


best_prompt = """You are a text-to-SQL expert. You will be given the following information:
1. Database schema: complete CREATE TABLE … DDL.
2. User Issue: a natural language description of the desired outcome or the current bug.
3. Problematic SQL: the query (or queries) that presently fails to meet the requirement.
4. Solution SQL: 

The input is as follows:
### Database Schema
{schema}

### User Issue
{user_issue}

### Problematic SQL
sql_list = {issue_sql}

### Solution SQL
sql_list = {sol_sql}

Your job is to analyse all of the above and determine whether the proposed solution SQL: 
1. can be executed exactly as written (i.e., is syntactically valid and references existing schema objects), and
2. fully and accurately resolves the user's issue.
Now generate your judgement as yes or no. Only output yes or no as your final answer without any explanation and comments.
"""