import os, json
import argparse

def load_jsonl(file_path):
    data = []
    with open(file_path, "r", encoding="utf-8") as file:
        for line in file:
            data.append(json.loads(line.strip()))
    return data

def save_jsonl(data, file_path):
    with open(file_path, "w", encoding="utf-8") as file:
        for entry in data:
            file.write(json.dumps(entry) + "\n")
            
            
def postprocess(result_jsonl, save_path):
    observation_json = {}
    for idx, content in enumerate(result_jsonl):
        info = {}
        info['status'] = content['status']
        info['exec_res'] = content['execution_result']
        info['error'] = content['error_message']
        observation_json[idx] = info
    json.dump(observation_json, open(save_path, 'w'), indent=4)

def parse_args() -> argparse.Namespace:
    parser = argparse.ArgumentParser(
        description="Post-process execution results and write observations."
    )
    parser.add_argument(
        "--result_path",
        help="Path to *action_N_output_with_status.jsonl*",
    )
    parser.add_argument(
        "--save_path",
        help="Where to store the processed observations JSON",
    )
    return parser.parse_args()
if __name__ == '__main__':
    args = parse_args()

    result_jsonl = load_jsonl(args.result_path)
    postprocess(result_jsonl, args.save_path)