
from utils.util import load_jsonl, re_keywords, save_jsonl, save_data_to_fac
from utils.db_utils import get_column_table_from_full_schema, get_pretty_schema
import os
import json
from src.prompts.react.generate_data_with_code_mp import final_prompt
import argparse

REACT_PROMPT = """<thought>{thought}</thought>
<action>{action}</action>
<observation>
{observation}
</observation>
"""

def get_final_prompt(data_jsonl, full_schema_jsonl, full_round_json, save_path):
    prompt_list = []
    for idx, content in enumerate(data_jsonl):
        schema = get_pretty_schema(idx, full_schema_jsonl, column_meaning_dict= None, selected_schema= None,
                               show_data = True, show_meaning= False)
        user_issue = content['query']
        issue_sql = content['issue_sql']
        history_list = full_round_json[str(idx)]
        react_list = []
        for history in history_list:
            flag = history['flag']
            action = history['action']
            if flag == 'True' or ('MISS' in action):
                continue
            # if ('MISS' in action):
            #     continue
            thought = history['thought']
            observation = history['observation']
            react = REACT_PROMPT.format(action = action, thought = thought, observation = observation)
            react_list.append(react)
        react_chain = '\n\n'.join(react_list)
        prompt = final_prompt.format(schema = schema, user_issue = user_issue, issue_sql = issue_sql, history = react_chain)
        prompt_list.append({'idx':idx, 'prompt':prompt})
    print(prompt_list[0]['prompt'])
    save_jsonl(prompt_list, save_path)
    return prompt_list

def parse_args() -> argparse.Namespace:
    parser = argparse.ArgumentParser(
        description="Create the final SQL-generation prompt file."
    )
    parser.add_argument(
        "--data_path",
        help="dev_data.jsonl"
    )
    parser.add_argument(
        "--full_schema_path",
        help="dev_full_schema_info.jsonl"
    )
    parser.add_argument(
        "--full_round_path",
        help="Full-round history JSON to read"
    )
    parser.add_argument(
        "--save_path",
        help="Where to write the final SQL prompt JSONL"
    )
    return parser.parse_args()
if __name__ == '__main__':
    args = parse_args()
    
    data_jsonl = load_jsonl(args.data_path)
    full_schema_jsonl = load_jsonl(args.full_schema_path)
    full_round_json = json.load(open(args.full_round_path, 'r'))
    get_final_prompt(data_jsonl, full_schema_jsonl, full_round_json, args.save_path)