

import re
from typing import Tuple
import os, json
from copy import deepcopy
from utils.util import load_jsonl, save_jsonl
import re
import pandas as pd
from copy import deepcopy
import argparse

def get_full_round(history_json, observation_json, save_path):
    final_historys = deepcopy(history_json)
    for idx, obs in observation_json.items():
        # idx = int(idx)
        exec_status = obs['status']
        if exec_status == 'success':
            try:
                exec_results = eval(obs['exec_res']).get('table_preview')
                if len(exec_results) > 1000: exec_results = ''
            except: exec_results = 'NULL'
            observation = f"execution status: {exec_status}\nexecution results:\n{exec_results}"
        else:
            exec_error = obs['error']
            observation = f"execution status: {exec_status}\nexecution error:\n{exec_error}"
        history_list = history_json[idx][:-1]
        prev_history = history_json[idx][-1]
        prev_history['observation'] = observation
        history_list.append(prev_history)
        final_historys[idx] = history_list
    
    json.dump(final_historys, open(save_path, 'w'), indent=4)

def parse_args() -> argparse.Namespace:
    parser = argparse.ArgumentParser(
        description="Merge observation + history into a full-round file."
    )
    parser.add_argument(
        "--observation_path",
        help="Observation JSON produced by exec-actions phase",
    )
    parser.add_argument(
        "--history_path",
        help="History JSON accumulated so far",
    )
    parser.add_argument(
        "--full_round_path",
        help="Where to write the merged full-round history",
    )
    return parser.parse_args()

if __name__ == '__main__':
    args = parse_args()
    observation_json = json.load(open(args.observation_path, 'r'))
    history_json = json.load(open(args.history_path, 'r'))
    get_full_round(history_json, observation_json, args.full_round_path)