from utils.db_utils import connect_postgresql
from utils.util import load_jsonl, re_keywords, save_jsonl, save_data_to_fac
from utils.db_utils import get_column_table_from_detail_schema
import os
from copy import deepcopy
import argparse

def postprocess(data_jsonl, gen_sql_jsonl):
    postprocess_data = []
    for idx, content in enumerate(data_jsonl):
        gen_sql = gen_sql_jsonl[idx]['response']
        # if not gen_sql.startswith('```sql'):
        #     gen_sql = '```sql\n' + gen_sql
        gen_sql = re_keywords(gen_sql, 'sql')
        if gen_sql == "" and gen_sql.startswith('```sql'):
            gen_sql = '```sql\n' + gen_sql
            gen_sql = re_keywords(gen_sql, 'sql')
        sql_list = gen_sql.split('\n\n')
        final_content = deepcopy(content)
        final_content['pred_sqls'] = sql_list
        postprocess_data.append(final_content)
    return postprocess_data

def parse_args():
    parser = argparse.ArgumentParser(
        description="Generate prompts for ReAct with code multi-planning."
    )
    parser.add_argument("--data_path", required=True, help="dev_data.jsonl")
    parser.add_argument("--sql_path", required=True, help="sql")
    parser.add_argument("--save_path", required=True, help="processed sql")
    return parser.parse_args()

if __name__ == '__main__':
    args = parse_args()
    data_jsonl = load_jsonl(args.data_path)
    gen_sql_jsonl = load_jsonl(args.sql_path)
    postprocess_data = postprocess(data_jsonl, gen_sql_jsonl)        
    save_jsonl(postprocess_data, args.save_path)