#!/usr/bin/env bash
model_path=${MODEL_PATH}
data_path=${DATA_PATH}
schema_path=${SCHEMA_PATH}

RES_DIR=${RES_DIR}
infer_data_save_dir=${INFER_DATA_SAVE_PATH}
infer_res_save_dir=${INFER_RES_SAVE_DIR}

mkdir -p "$RES_DIR"
prompt_dir="$RES_DIR/prompts"
mkdir -p "$prompt_dir"
thought_action_dir="$RES_DIR/thought_actions"
mkdir -p "$thought_action_dir"
observations_dir="$RES_DIR/observations"
mkdir -p "$observations_dir"
history_dir="$RES_DIR/history"
mkdir -p "$history_dir"
full_round_dir="$RES_DIR/full_round"
mkdir -p "$full_round_dir"
exec_actions_dir="$RES_DIR/exec_actions"
mkdir -p "$exec_actions_dir"
final_sql_dir="$RES_DIR/final_sqls"
mkdir -p "$final_sql_dir"

TURNS=5
IDX=0
initial_thought_prompt_path="$prompt_dir/initial_thought_prompt.jsonl"
initial_thought_actions_path="$thought_action_dir/initial_thought_actions.jsonl"

python ./construct_training_data/generate_initial_thought.py --data_path "$data_path" --schema_path "$schema_path" --meta_plan_path "$meta_plan_path" --save_path "$initial_thought_prompt_path" --turns "$TURNS"



full_round_path="$full_round_dir/full_round_history_$IDX.json"
exec_action_sub_dir="$exec_actions_dir/action_$IDX"
mkdir -p "$exec_action_sub_dir"
exec_action_path="$exec_action_sub_dir/action_$IDX.jsonl"
history_path="$history_dir/history_$IDX.json"

python ./construct_training_data/extract_comp.py --data_path "$data_path" --full_round_path "$full_round_path" --react_response_path "$initial_thought_actions_path" --exec_action_path "$exec_action_path" --history_path "$history_path"

python ./evaluation_postgresql_for_react/wrapper_evaluation_postgresql.py --pred_file "$exec_action_path" --gt_file "$data_path" --logging "false" --mode "pred"

exec_action_status_path="$exec_action_sub_dir/action_${IDX}_output_with_status.jsonl"
observation_path="$observations_dir/obs_$IDX.json"

python ./construct_training_data/exec_postprocess.py --result_path "$exec_action_status_path" --save_path "$observation_path"
python ./construct_training_data/get_full_round.py --observation_path "$observation_path" --history_path "$history_path" --full_round_path "$full_round_path"


for IDX in $(seq 1 $((TURNS - 1))); do

    echo "Current IDX is $IDX."

    full_round_path="$full_round_dir/full_round_history_$((IDX - 1)).json"
    initimidate_thought_prompt_path="$prompt_dir/initimidate_thought_prompt_${IDX}.jsonl"

    python ./construct_training_data/generate_intermidate_thought.py --data_path "$data_path" --full_schema_path "$schema_path" --meta_plan_path "$meta_plan_path" --full_round_path "$full_round_path" --save_path "$initimidate_thought_prompt_path"

    intermidiate_thought_actions_path="$thought_action_dir/intermidiate_thought_actions_${IDX}.jsonl"
    python ./construct_training_data/vllm_infer.py --model_path "$model_path" --prompt_path "$initimidate_thought_prompt_path" --output_path "$intermidiate_thought_actions_path"

    exec_action_sub_dir="$exec_actions_dir/action_$IDX"
    mkdir -p "$exec_action_sub_dir"
    exec_action_path="$exec_action_sub_dir/action_$IDX.jsonl"
    history_path="$history_dir/history_$IDX.json"
    python ./construct_training_data/extract_comp.py --data_path "$data_path" --full_round_path "$full_round_path" --react_response_path "$intermidiate_thought_actions_path" --exec_action_path "$exec_action_path" --history_path "$history_path"

    python ./evaluation_postgresql_for_react/wrapper_evaluation_postgresql.py --pred_file "$exec_action_path" --gt_file "$data_path" --logging "false" --mode "pred"

    exec_action_status_path="$exec_action_sub_dir/action_${IDX}_output_with_status.jsonl"
    observation_path="$observations_dir/obs_$IDX.json"
    python ./construct_training_data/exec_postprocess.py --result_path "$exec_action_status_path" --save_path "$observation_path"

    next_full_round_path="$full_round_dir/full_round_history_${IDX}.json"
    python ./construct_training_data/get_full_round.py --observation_path "$observation_path" --history_path "$history_path" --full_round_path "$next_full_round_path"
done






final_round_path="$full_round_dir/full_round_history_$(($TURNS - 1)).json"
final_sql_prompt_path="$prompt_dir/final_sql_prompt.jsonl"
python ./construct_training_data/get_final_sql.py --data_path "$data_path" --full_schema_path "$schema_path" --full_round_path "${final_round_path}" --save_path "${final_sql_prompt_path}"

final_sql_path="$final_sql_dir/final_sql.jsonl"
python ./construct_training_data/vllm_infer.py --model_path "$model_path" --prompt_path "$final_sql_prompt_path" --output_path "$final_sql_path"

processed_final_sql_path="$final_sql_dir/processed_final_sql.jsonl"
python ./construct_training_data/postprocess_sql.py --data_path "$data_path" --sql_path "$final_sql_path" --save_path "$processed_final_sql_path"

