import os, json


def load_jsonl(file_path):
    data = []
    with open(file_path, "r", encoding="utf-8") as file:
        for line in file:
            data.append(json.loads(line.strip()))
    return data


def get_error_logs(data_jsonl, gold_data_jsonl, save_path):
    final_log = {}
    for idx, content in enumerate(data_jsonl):
        gold_content = gold_data_jsonl[idx]
        if gold_content['status'] == 'success' and content['status'] == 'failed':
            tmp_dic = {}
            tmp_dic['db_id'] = content['db_id']
            tmp_dic['user_issue'] = content['query']
            tmp_dic['preprocess_sql'] = content['preprocess_sql']
            tmp_dic['error_sql'] = content['pred_sqls']
            tmp_dic['correct_sql'] = gold_content['pred_sqls']
            final_log[idx] = tmp_dic
    json.dump(final_log, open(save_path, 'w'), indent=4)


if __name__ == '__main__':
    data_jsonl_path = '/app/SO_evaluation/evaluation_postgresql/sql_res/processed_sql_with_at_react_output_with_status.jsonl'
    gold_data_jsonl_path = '/app/SO_evaluation/evaluation_postgresql/sql_res/baseline/qwen32b_dev_debug_baseline_output_with_status.jsonl'
    save_path = '/app/SO_evaluation/evaluation_postgresql/sql_res/log/react_vs_baseline.json'
    
    data_jsonl = load_jsonl(data_jsonl_path)
    gold_data_jsonl = load_jsonl(gold_data_jsonl_path)
    
    get_error_logs(data_jsonl, gold_data_jsonl, save_path)