system_prompt = """You are an expert in text-to-SQL."""


meta_plan_code_backwards_prompt = """You are an text-to-SQL expert. For every task you will receive: 1) Database schema DDL 2) User issue 3) Problematic SQL.
Your reponse meta-plan should include:
1. User Issue Summary: what the user is trying to accomplish or what is wrong with the current query. Wrap your answer in the <user_issue_summary>[Your Answer]</user_issue_summary> tag in the format of <user_issue_summary> … </user_issue_summary>
2. Selected Table: Output only the table names that will appear in the final query, nothing more—no columns, no comments. Wrap the comma-separated list inside the custom tag exactly as shown: <selected_table>table1, table2, table3</selected_table>
3. Step-by-step pythonic debugging Plan (to be wrapped inside <debugging_plan> tags): Write a block of symbolic Python code of the logical actions you will take in the debugging process, followed by an inline # comment. The debugging plan should be no more than 5 steps and no duplicates allowed.

The formatting rules of meta-plan are: 
1) One statement per line. Each line MUST be a symbolic python function with a # comment that explains the purpose of the code. DO NOT directly use pure natural language instead of code. 
2) Each line represents a single test or transformation that could later be expressed as its own SQL statement (row counts, NULL scans, join validation, etc.), such as `aggregate(table="budget", by="event_id", count_on="entry_id", alias="expense_cnt")  # Derive missing aggregation.` There's no need to start with the fixed function. You could flexibly design your onw debugging plan. 
3) Highlight suspected causes  (e.g., “# Missing aggregation on planning”) and briefly state the SQL check you would run to confirm or refute in the comments. 
4) Use imperative verbs such as “Verify … ”, “Count … ”, “Compare …” in comment and stick to the reasoning path—do not rewrite the whole query here.
5) Wrap the entire list in the tag shown below:
<debugging_plan>
[Your Answer]
</debugging_plan>
Keep the plan in 5 steps. Do NOT produce a second <debugging_plan>, extra tags, or blank lines after the block.



The input is as follows:
### Database Schema
{schema}

### User Issue
{user_issue}

### Problematic SQL
{issue_sql}


Now generate the meta-plan for me in the format I desire.
### Meta Plan
<user_issue_summary>
"""

traj_prompt = """Interact with the "{db_id}" database using postgre SQL to solve the user issue. You will be given the following information:
1. Database schema: complete CREATE TABLE … DDL.
2. User Issue: a natural language description of the desired outcome or the current bug.
3. Problematic SQL: the query (or queries) that presently fails to meet the requirement.
4. Meta Plan: Provide a compact block of symbolic Python code, one statement per line, where each call represents a hypothesis-driven diagnostic SQL step (e.g., row counts, NULL scans, join validation). End every line with an inline # comment that states the purpose or suspected error. This code is a private reasoning aid that guides you from the problematic SQL to the correct query. Since it's not executable and just a meta-plan, some lines may be speculative or imperfect. You may form your own plan whenever live evidence suggests a better route.

Use interleaving Thought, Action, Observation steps. 
Thought can reason about the possible errors or other information you think you need for debugging about the current situation. For instance, it could be 1) diagnosis of the bug you see in the current query, or 2) Hypotheses you want to confirm (e.g., Maybe the join is missing a date filter). 3) Reasoning that led you to the next SQL step (checking row counts, inspecting NULLs, etc.) 4) A brief plan for what you will try next.
Action can only be the executable postgre SQL. The observartion would be the exectuation results feedback from the environment. 
Wrap your thought in the <thought>[Your Thought]</thought> tag and your action in <action>[Executable SQL]</action>


The input for you is as follows:
### Database Schema
{schema}

### User Issue
{user_issue}

### Problematic SQL
{issue_sql}

### Meta Plan
{meta_plan}

Important Rules:
1. MOST IMPORTANT: Wrap your thought in the <thought>[Your Thought]</thought> tag and your action in <action>[Executable SQL]</action>
2. The action inside the <action></action> tags must be pure PostgreSQL statements that can be executed directly, without any comments or needs for additional post-processing.

Now generate the thought and action of the next round given the trajectory history and the input. You still have {turn} turns left.
### React
"""


traj_wo_mp_prompt = """Interact with the "{db_id}" database using postgre SQL to solve the user issue. You will be given the following information:
1. Database schema: complete CREATE TABLE … DDL.
2. User Issue: a natural language description of the desired outcome or the current bug.
3. Problematic SQL: the query (or queries) that presently fails to meet the requirement.

Use interleaving Thought, Action, Observation steps. 
Thought can reason about the possible errors or other information you think you need for debugging about the current situation. For instance, it could be 1) diagnosis of the bug you see in the current query, or 2) Hypotheses you want to confirm (e.g., Maybe the join is missing a date filter). 3) Reasoning that led you to the next SQL step (checking row counts, inspecting NULLs, etc.) 4) A brief plan for what you will try next.
Action can only be the executable postgre SQL. The observartion would be the exectuation results feedback from the environment. 
Wrap your thought in the <thought>[Your Thought]</thought> tag and your action in <action>[Executable SQL]</action>


The input for you is as follows:
### Database Schema
{schema}

### User Issue
{user_issue}

### Problematic SQL
{issue_sql}


Important Rules:
1. MOST IMPORTANT: Wrap your thought in the <thought>[Your Thought]</thought> tag and your action in <action>[Executable SQL]</action>
2. The action inside the <action></action> tags must be pure PostgreSQL statements that can be executed directly, without any comments or needs for additional post-processing.

Now generate the thought and action of the next round given the trajectory history and the input. You still have {turn} turns left.
### React
"""


final_prompt = """You are a text-to-SQL expert. You will be given the following information:
1. Database schema: complete CREATE TABLE … DDL.
2. User Issue: a natural language description of the desired outcome or the current bug.
3. Problematic SQL: the query (or queries) that presently fails to meet the requirement.
4. React Thought Chain: A history of your prior debugging iterations, formatted as a sequence of thought → action → observation tuples. Each tuple is separated from the next by a blank line (\\n\\n).
	•	Thought - Your reasoning: hypotheses about errors, assumptions, or additional data requirements.
	•	Action - A pure PostgreSQL statement executed to test or correct the issue.
	•	Observation - The execution result returned by the database engine.
 
Your task is to understand all these contents and generate the final Postgre SQL that could accurately solve the user issue.

The input is as follows:
### Database Schema
{schema}

### User Issue
{user_issue}

### Problematic SQL
sql_list = {issue_sql}

### React Thought Chain
{history}

Now generate the final Postgre SQL that could accurately solve the user issue and could be directly executed. Wrap you answer in the ```sql\\n[Your Answer]``` tag. Do not give me extra explanations or comments.
```sql
"""