

import re
from typing import Tuple
import os, json
from copy import deepcopy
from utils.util import load_jsonl, save_jsonl
import argparse

THOUGHT_RE = re.compile(r"<thought>(.*?)</thought>", re.DOTALL | re.IGNORECASE)
ACTION_RE  = re.compile(r"<action>(.*?)</action>",  re.DOTALL | re.IGNORECASE)

def exact_last_thought_action(response):
    if not response.startswith('<thought>'):
        response = '<thought>' + response
    if not response.endswith('</action>'):
        response = response + '</action>'
    thoughts = THOUGHT_RE.findall(response)
    actions  = ACTION_RE.findall(response)
    if not thoughts or not actions:
        # print(response)
        thoughts = [""]
        actions = ["[MISS]"]
    thought = thoughts[-1].strip()
    action = actions[-1].strip()
    return thought, action



def generate_thought_action_part(data_jsonl, react_response_jsonl, history_json, exec_action_save_path, history_json_save_path):
    exec_action = []
    new_history_json = {}
    react_response_dict = {}
    for i, content in enumerate(react_response_jsonl):
        idx = content['idx']
        react_response_dict[idx] = content
        
    for idx, content in enumerate(data_jsonl):
        history = history_json.get(str(idx))
        history = history if history else []
        end_flag = 'False'
        react_content = react_response_dict.get(idx)
        if react_content:
            react_response = react_content['response']
            thought, action = exact_last_thought_action(react_response)
            
            if '[DONE]' in action: 
                end_flag = 'True'
            
            turn = len(history)
            tmp_data = {'turn': turn, 'thought': thought, 'action': action, 'flag': end_flag}
            history.append(tmp_data)
            content = data_jsonl[idx]
            tmp_content = deepcopy(content)
            tmp_content['pred_sqls'] = action.split('\n\n')
            exec_action.append(tmp_content)
            
        new_history_json[idx] = history
        
    
    json.dump(new_history_json, open(history_json_save_path, 'w'), indent=4)
    save_jsonl(exec_action, exec_action_save_path)
    
def parse_args() -> argparse.Namespace:
    parser = argparse.ArgumentParser(
        description="Build exec-actions + history JSONs from ReAct replies"
    )
    parser.add_argument(
        "--data_path",
        help="Path to dev_data.jsonl",
    )
    parser.add_argument(
        "--full_round_path",
        help="Existing history json; created if absent",
    )
    parser.add_argument(
        "--react_response_path",
        help="Intermidate ReAct model responses",
    )
    parser.add_argument(
        "--exec_action_path",
        help="Where to write the executable-action JSONL",
    )
    parser.add_argument(
        "--history_path",
        help="Where to write the updated history json",
    )

    return parser.parse_args()

if __name__ == '__main__':
    args = parse_args()
    data_jsonl = load_jsonl(args.data_path)
    react_response_jsonl = load_jsonl(args.react_response_path)
    if os.path.exists(args.full_round_path): 
        history_json = json.load(open(args.full_round_path, 'r'))
    else: history_json = {}
    generate_thought_action_part(data_jsonl, react_response_jsonl, history_json, args.exec_action_path, args.history_path)
        
    