import re
from typing import Tuple
import os, json
from copy import deepcopy
from utils.util import load_jsonl, save_jsonl
import argparse
import copy

THOUGHT_RE = re.compile(r"<thought>(.*?)</thought>", re.DOTALL | re.IGNORECASE)
# ACTION_RE  = re.compile(r"<action>(.*?)</action>",  re.DOTALL | re.IGNORECASE)

def exact_last_thought(response):
    if not response.startswith('<thought>'):
        response = '<thought>' + response
    thoughts = THOUGHT_RE.findall(response)
    if not thoughts:
        # print(response)
        thoughts = [""]
    thought = thoughts[-1].strip()
    return thought

def merge_jsonl(record_jsonl_path, react_response_jsonl):
    record_jsonl = load_jsonl(record_jsonl_path)
    new_record_jsonl = []
    for i, content in enumerate(react_response_jsonl):
        record = record_jsonl[i]
        new_record = copy.deepcopy(record)
        new_record['response'] = content['predict']
        new_record_jsonl.append(new_record)
    save_jsonl(new_record_jsonl, record_jsonl_path)
    return new_record_jsonl


def generate_thought(data_jsonl, record_jsonl, save_path):
    react_response_dict = {}
    for i, content in enumerate(record_jsonl):
        idx = content['idx']
        react_response_dict[idx] = content
        
    thought_dict = {}
    for idx, content in enumerate(data_jsonl):
        react_content = react_response_dict.get(idx)
        if react_content:
            react_response = react_content['response']
            thought = exact_last_thought(react_response)
            thought_dict[idx] = thought
        
    
    json.dump(thought_dict, open(save_path, 'w'), indent=4)

def parse_args():
    parser = argparse.ArgumentParser(
        description="Generate prompts for ReAct with code multi-planning."
    )
    parser.add_argument("--data_path", required=True, help="dev_data.jsonl")
    parser.add_argument("--record_save_path", required=True, help="record of prompt")
    parser.add_argument("--react_response_path", required=True, help="react response")
    parser.add_argument("--save_path", required=True, help="thought prompt path")

    return parser.parse_args()

if __name__ == '__main__':
    args = parse_args()
    data_jsonl = load_jsonl(args.data_path)
    react_response_jsonl = load_jsonl(args.react_response_path)
    record_jsonl = merge_jsonl(args.record_save_path, react_response_jsonl)
    
    generate_thought(data_jsonl, record_jsonl, args.save_path)