import re
from typing import Tuple
import os, json
from copy import deepcopy
from utils.util import load_jsonl, save_jsonl, re_keywords
import argparse
import copy

ACTION_RE  = re.compile(r"<action>(.*?)</action>",  re.DOTALL | re.IGNORECASE)

def exact_last_action(response):
    actions  = ACTION_RE.findall(response)
    if not actions:
        actions = ["[MISS]"]
    action = actions[-1].strip()
    return action

def postprocess_action(data_jsonl, action_jsonl, save_path):
    action_dict = {}
    for i, content in enumerate(action_jsonl):
        idx = content['idx']
        action = re_keywords(content['response'], 'sql')
        if not action:
            action = exact_last_action(content['response'])
        action_dict[idx] = action
    
    exec_action = []
    for idx, content in enumerate(data_jsonl):
        # print(idx)
        action = action_dict.get(idx)
        tmp_content = copy.deepcopy(content)
        if not action: tmp_content['pred_sqls'] = '[DONE]'
        else: tmp_content['pred_sqls'] = action.split('\n\n')
        exec_action.append(tmp_content)
    
    save_jsonl(exec_action, save_path)

def parse_args():
    parser = argparse.ArgumentParser(
        description="Generate prompts for ReAct with code multi-planning."
    )
    parser.add_argument("--data_path", required=True, help="dev_data.jsonl")
    parser.add_argument("--action_path", required=True, help="action_path")
    parser.add_argument("--processed_action_path", required=True, help="processed action path")
    
    return parser.parse_args()

if __name__ == '__main__':
    args = parse_args()
    data_jsonl = load_jsonl(args.data_path)
    action_jsonl = load_jsonl(args.action_path)
    postprocess_action(data_jsonl, action_jsonl, args.processed_action_path)