#!/usr/bin/env bash
model_path=${MODEL_PATH}
data_path=${DATA_PATH}
schema_path=${SCHEMA_PATH}

RES_DIR=${RES_DIR}
infer_data_save_dir=${INFER_DATA_SAVE_PATH}
infer_res_save_dir=${INFER_RES_SAVE_DIR}

mkdir -p "$RES_DIR"
prompt_dir="$RES_DIR/prompts"
mkdir -p "$prompt_dir"
actions_dir="$RES_DIR/actions"
mkdir -p "$actions_dir"
full_round_dir="$RES_DIR/full_round"
mkdir -p "$full_round_dir"
final_sql_dir="$RES_DIR/final_sqls"
mkdir -p "$final_sql_dir"
thought_dir="$RES_DIR/thought"
mkdir -p "$thought_dir"
record_dir="$RES_DIR/record"
mkdir -p "$record_dir"

TURNS=5
IDX=0



file_name="initial_traj"
record_path="$record_dir/${file_name}_record.jsonl"
python ./infer/construct_first_traj_data.py --data_path "$data_path" --schema_path "$schema_path" --save_dir "$infer_data_save_dir" --file_name "$file_name" --record_save_path "$record_path" --turns "$TURNS"

#llamafactory infer initial_traj

initial_traj_path="$infer_res_save_dir/${file_name}/generated_predictions.jsonl"
thought_path="$thought_dir/thought_0.jsonl"

action_prompt_sub_dir="$prompt_dir/get_actions"
mkdir -p "$action_prompt_sub_dir"
action_prompt_path="$action_prompt_sub_dir/action_0.jsonl"
full_round_path="$full_round_dir/full_round_history_0.json"

action_save_sub_dir="$actions_dir/action_0"
mkdir -p "$action_save_sub_dir"
action_path="$action_save_sub_dir/action_0.jsonl"
processed_action_path="$action_save_sub_dir/processed_action_0.jsonl"

python ./infer/extract_thought.py --data_path "$data_path" --record_save_path "$record_path" --react_response_path "$initial_traj_path" --save_path "$thought_path" 
python ./infer/generate_action_prompt_for_phi.py --data_path "$data_path" --schema_path "$schema_path" --full_round_path "$full_round_path" --thought_path "$thought_path" --save_path "$action_prompt_path"

python ./infer/vllm_infer.py --model_path "$model_path" --prompt_path "$action_prompt_path" --output_path "$action_path" 
python ./infer/postprocess_action_for_phi.py --data_path "$data_path" --action_path "$action_path" --processed_action_path "$processed_action_path" 

# docker get observation from action
processed_status_path="$action_save_sub_dir/processed_action_0_output_with_status.jsonl"
python ./infer/get_full_round.py --data_path "$data_path" --thought_path "$thought_path" --processed_action_path "$processed_action_path" --processed_status_path "$processed_status_path" --full_round_path "$full_round_path" --save_path "$full_round_path"


for IDX in $(seq 1 $((TURNS - 1))); do

    echo "Current IDX is $IDX."
    file_name="intermediate_traj_${IDX}"
    record_path="$record_dir/${file_name}_record.jsonl"
    full_round_path="$full_round_dir/full_round_history_$((IDX - 1)).json"

    python ./infer/construct_intermidate_traj_data.py --data_path "$data_path" --schema_path "$schema_path" --full_round_path "$full_round_path" --record_save_path "$record_path" --save_dir "$infer_data_save_dir" --file_name "$file_name" --record_save_path "$record_path"

    #llamafactory infer intermidiate_traj
    intermediate_traj_path="$infer_res_save_dir/${file_name}/generated_predictions.jsonl"
    thought_path="$thought_dir/thought_${IDX}.jsonl"
    
    action_prompt_sub_dir="$prompt_dir/get_actions"
    mkdir -p "$action_prompt_sub_dir"
    action_prompt_path="$action_prompt_sub_dir/action_${IDX}.jsonl"
    full_round_path="$full_round_dir/full_round_history_$((IDX - 1)).json"

    action_save_sub_dir="$actions_dir/action_${IDX}"
    mkdir -p "$action_save_sub_dir"
    action_path="$action_save_sub_dir/action_${IDX}.jsonl"
    processed_action_path="$action_save_sub_dir/processed_action_${IDX}.jsonl"

    python ./infer/extract_thought.py --data_path "$data_path" --record_save_path "$record_path" --react_response_path "$intermediate_traj_path" --save_path "$thought_path"
    python /bird_critic/src/workflow_react/construct_interact_infer_data_wo_mp/generate_action_prompt_for_phi.py --data_path "$data_path" --schema_path "$schema_path" --full_round_path "$full_round_path" --thought_path "$thought_path" --save_path "$action_prompt_path"

    python ./infer/vllm_infer.py --model_path "$model_path" --prompt_path "$action_prompt_path" --output_path "$action_path" 
    python /bird_critic/src/workflow_react/construct_interact_infer_data_wo_mp/postprocess_action_for_phi.py --data_path "$data_path" --action_path "$action_path" --processed_action_path "$processed_action_path" 

    # docker get observation from action

    processed_status_path="$action_save_sub_dir/processed_action_${IDX}_output_with_status.jsonl"
    save_path="$full_round_dir/full_round_history_${IDX}.json"
    python ./infer/get_full_round.py --data_path "$data_path" --thought_path "$thought_path" --processed_action_p`ath "$processed_action_path" --processed_status_path "$processed_status_path" --full_round_path "$full_round_path" --save_path "$save_path"

done




final_round_path="$full_round_dir/full_round_history_$(($TURNS - 1)).json"
sub_final_sql_prompt_dir="$prompt_dir/final_sqls"
mkdir -p "$sub_final_sql_prompt_dir"

final_sql_prompt_path="$sub_final_sql_prompt_dir/final_sql_prompt.jsonl"
final_sql_path="$final_sql_dir/final_sql.jsonl"
processed_final_sql_path="$final_sql_dir/processed_final_sql.jsonl"

python ./infer/get_final_sql.py --data_path "$data_path" --schema_path "$schema_path" --full_round_path "${final_round_path}" --save_path "${final_sql_prompt_path}"
python ./infer/vllm_infer.py --model_path "$model_path" --prompt_path "$final_sql_prompt_path" --output_path "$final_sql_path"
python ./infer/postprocess_sql.py --data_path "$data_path" --sql_path "$final_sql_path" --save_path "$processed_final_sql_path"

