import json
import os
import re

def load_jsonl(file_path):
    data = []
    with open(file_path, "r", encoding="utf-8") as file:
        for line in file:
            data.append(json.loads(line.strip()))
    return data

def save_jsonl(data, file_path):
    with open(file_path, "w", encoding="utf-8") as file:
        for entry in data:
            file.write(json.dumps(entry) + "\n")


def save_data_to_fac(data, save_dir,file_name):
    data_save_path = os.path.join(save_dir, f"{file_name}.json")
    json.dump(data, open(data_save_path, 'w'), indent=4)
    info_path = os.path.join(save_dir, 'dataset_info.json')
    if not os.path.exists(info_path):
        data_info = {}
    else:
        data_info = json.load(open(info_path, 'r'))

    data_info[file_name] = {
        'file_name': f"{file_name}.json",
        "columns": {
                    "prompt": "instruction",
                    "response": "output",
                    "system": "system"
                    }
        }
    json.dump(data_info, open(info_path, 'w'), indent=4)
    
def prompt_json2jsonl(data_path, save_path):
    data = json.load(open(data_path, 'r'))
    final_data = []
    for idx, content in data.items():
        tmp = {'idx': idx, 'prompt': content}
        final_data.append(tmp)
    save_jsonl(final_data, save_path)

def re_keywords(input, keyword):
    match = re.search(fr"```{keyword}(.*?)```", input, re.DOTALL)
    tmp = match.group(1).strip() if match else None
    if not tmp: tmp = ''
    return tmp
