
# Learning Harmonic Molecular Representation on Riemannian Manifold
## Setup
```bash 
bash setup.sh
```
## Data preparation
```
bash datga_gen/$dataset_name$/auto_gen.sh
python3 core/data_preprocess.py
```
## Model
### Training
```python3
python3 step1_train.py --unmute-tqdm --test-freq 5
```
Or you can use multi-gpu with:
```python3
horovodrun -np num_gpus step1_train.py --unmute-tqdm --test-freq 5
```

### Predict Binding Site
```python3
python3 step2_predict.py
```
### Rigid Docking
```python3
python3 step3_dock.py
```
More configs see config.py.