#!/bin/bash

args=(
--unmute-tqdm
--test-freq 5
) 

# preprocess dataset
python3  core/data_preprocess.py "${args[@]}" 

# train model on RCSB dataset
python3 step1_train.py "${args[@]}" | tee results_train.txt 
# # for multi-gpu you can use:
# # horovodrun -np num_gpus python3 step1_train.py "${args[@]}" | tee results_train.txt 

# # predict DB5 protein binding site
python3 step2_predict.py "${args[@]}" 

# # generate DB5 complex conformations
python3 step3_dock.py "${args[@]}" 


