import torch


def get_cos_dist(X, Y, eps=1e-6):
    # https://math.stackexchange.com/questions/3241174/scale-cosine-similarity-between-vectors-to-range-0-1
    
    sim = torch.einsum('bnd,bmd->bnm', X, Y)
    dist = torch.arccos(sim - eps) / torch.tensor(3.141592653589793, device=X.device)
    return dist