import math
import torch
from torch import nn
from torch import Tensor


class PositionalEncoding1d(nn.Module):

    def __init__(self, d_model: int, dropout: float = 0.0, max_len: int = 20):
        super().__init__()
        self.dropout = nn.Dropout(p=dropout)

        position = torch.arange(max_len).unsqueeze(1)
        div_term = torch.exp(torch.arange(0, d_model, 2) * (-math.log(10000.0) / d_model))
        pe = torch.zeros(1, max_len, d_model)
        pe[0, :, 0::2] = torch.sin(position * div_term)
        pe[0, :, 1::2] = torch.cos(position * div_term)
        self.register_buffer('pe', pe)

    def forward(self, batch_size, seq_len) -> Tensor:
        x = self.pe[:, :seq_len, :]
        x = x.repeat(batch_size, 1, 1)
        return self.dropout(x)