import os
import random
import numpy as np
import torch

def set_all_seeds(seed):
    random.seed(seed)
    os.environ['PYTHONHASHSEED'] = str(seed)
    np.random.seed(seed)
    torch.manual_seed(seed)
    torch.cuda.manual_seed(seed)
    torch.backends.cudnn.deterministic = True

# only use if tensors
def objectsroom_mask_transform(mask):
    mask = torch.where(mask > 0, 1, 0)
    return mask.float()

def objectsroom_image_transform(img):
    img = (img / 255.0 ) * 2.0 - 1.0
    return img.float()