# Expert Demonstration Datasets

This repository contains the expert demonstration datasets used in our paper.

## Overview

We provide expert trajectories in `.h5` format for the environments studied in our work. Each demonstration is stored as a separate file, and the file names encode the return and episode length of the contained trajectory for ease of inspection.

- **Gymnasium environments**: 16 demonstrations per environment  
- **DeepMind Control Suite environments**: 32 demonstrations per environment  
  *(There is no specific reason for this discrepancy; we use at most 11 trajectories per environment in the paper.)*

## File Naming Convention

Each file is named as follows:
```bash
<trajectory_id>_L<episode_length>_R<episode_return>.h5
```
For example: `004_L1000_R985.h5` means it is the fourth trajectory of the dataset, and in the episode therein, the expert has collected a return of 985 over 1000 steps.


## Contents of Each File

Each `.h5` file contains a single expert trajectory, including:
- Observations
- Actions
- Next observations
- Termination flags

The data format is compatible with `torchrl.TensorDict.from_h5` for convenient loading and integration.