# PyTorch Implementation of Deep Fair Discriminative Clustering
This folder provides a [PyTorch](https://pytorch.org/) implementation of the *Deep Fair Discriminative Clustering* method presented in our
 ICLR 2022 submission.

## Installation
This code is written in `Python 3.6` and requires the packages listed in `requirements.txt`.

Note our implementation also requires Gurobi Optimizer package, here are the tips for installing Gurobi for python: https://support.gurobi.com/hc/en-us/articles/360044290292-How-do-I-install-Gurobi-for-Python-

To run the code, we recommend setting up a virtual environment, e.g. using `virtualenv` or `conda`:

### `virtualenv`
```
# pip install virtualenv
cd <path-to-Deep-Fair-Discriminative-Clustering-PyTorch-directory>
virtualenv myenv
source myenv/bin/activate
pip install -r requirements.txt
```

### `conda`
```
cd <path-to-Deep-Fair-Discriminative-Clustering-PyTorch-directory>
conda create --name myenv
source activate myenv
while read requirement; do conda install -n myenv --yes $requirement; done < requirements.txt
```

## Running experiments

We have implemented the deep clustering datasets (HAR, MNIST-USPS, Reverse-MNIST) and traditional fair clustering datasets (Census, Credit, Bank) with simple LeNet-type networks and fully connected networks. Have a look into `main.py` for all possible arguments and options.

### HAR example (deep clustering dataset)
```
cd <path-to-Deep-Fair-Discriminative-Clustering-PyTorch-directory>

# activate virtual environment
source myenv/bin/activate  # or 'source activate myenv' for conda

# create folder for experimental output
mkdir log/HAR_test

# change to source directory
cd src

# run experiment
python main.py har har_rim ../log/har_test ../data 4.0 --objective dfdc --lr 0.0002 --n_epochs 100 --batch_size 256
```
This example trains a deep fair clustering model on HAR dataset with optimal group-level fairness constraints.


### Credit example (traditional clustering dataset)
```
cd <path-to-Deep-Fair-Discriminative-Clustering-PyTorch-directory>

# activate virtual environment
source myenv/bin/activate  # or 'source activate myenv' for conda

# create folder for experimental output
mkdir log/credit_test

# change to source directory
cd src

# run experiment
python main.py credit credit_rim ../log/credit_test ../data 5.0 --objective dfdc --lr 0.0002 --n_epochs 80 --batch_size 256 --weight_decay 0.0001
```
This example trains a deep fair clustering model on Credit dataset with optimal group-level fairness constraints.

