from torch.utils.data import Subset
from torch.utils.data import ConcatDataset
from PIL import Image
from torch.utils.data import Dataset, DataLoader
from base.torchvision_dataset import TorchvisionDataset
from .preprocessing import get_target_label_idx, global_contrast_normalization
from skimage import io, color
import numpy as np
import torchvision.transforms as transforms
import os
import torch
import pandas as pd
from torch.utils import data
from scipy import io

class ADULT_Dataset(TorchvisionDataset):

    def __init__(self, root: str):
        super().__init__(root)
        train_set = adult(root=self.root, train=True)
        self.train_set = train_set
        test_set = adult(root=self.root, train=False)
        self.test_set = test_set
        self.train_size = len(self.train_set)

class adult(data.Dataset):
    def __init__(self, root, train=True):
        self.root = os.path.expanduser(root)
        print("self.root:", self.root)
        self.training_file = self.root+"/adult/adult_data.npz"
        self.attr_file = self.root+"/adult/adult_attr.p"

        self.train = train
        self.use_cuda = torch.cuda.is_available()
        adult_train = np.load(self.training_file)
        import pickle
        self.attrs = pickle.load(open(self.attr_file, "rb"))
        total_l = 0
        for key in self.attrs['sex'].keys():
            total_l += len(self.attrs['sex'][key])
        temp_attr = np.zeros((total_l, ))

        for k, val in self.attrs['sex'].items():
            temp_attr[val] = k
        self.train_attrs = temp_attr
        self.test_attrs = temp_attr
        self.train_data, self.train_labels = torch.tensor(adult_train['data'], dtype=torch.float32), torch.tensor(adult_train['labels'], dtype=torch.int)
        self.test_data, self.test_labels = self.train_data, self.train_labels
        if self.use_cuda == True:
            self.train_attrs = torch.from_numpy(self.train_attrs)
            self.train_data = self.train_data.cuda()
            self.train_attrs = self.train_attrs.cuda()
            self.train_labels = self.train_labels.cuda()
            self.test_attrs = torch.from_numpy(self.test_attrs)
            self.test_data = self.test_data.cuda()
            self.test_attrs = self.test_attrs.cuda()
            self.test_labels = self.test_labels.cuda()

    def __getitem__(self, index):
        img, attr, target = self.train_data[index], self.train_attrs[index], self.train_labels[index]
        return img, target, index, attr
    def __len__(self):
        if self.train:
            return len(self.train_data)
        else:
            return len(self.test_data)


