"""Packaged LayerNAS spec to search mobilenet search space.

NOTE: this code does not work by itself,
it depends on internal infra to run mobilenet training.

"""

from typing import List
from absl import logging
import pyglove as pg

import layer_nas_oss as layer_nas



SEARCH_SPEC = {
    'schema': ['kernel_size', 'strides', 'filters', 'se_ratio',
               'expanded_filters', 'activation'],
    'value': [
        [
            ([3], [1], 24, None, [None], layers.Swish6()),
            ([3], [1], 20, None, [None], layers.Swish6()),
            ([3], [1], 18, None, [None], layers.Swish6()),
            ([3], [1], 16, None, [None], layers.Swish6()),
            ([3], [1], 14, None, [None], layers.Swish6()),
        ],
        [
            ([None], [2, 1], 36, None, [None], layers.Swish6()),
            ([None], [2, 1], 32, None, [None], layers.Swish6()),
            ([None], [2, 1], 28, None, [None], layers.Swish6()),
            ([None], [2, 1], 24, None, [None], layers.Swish6()),
            ([None], [2, 1], 20, None, [None], layers.Swish6()),
            ([None], [2, 1], 16, None, [None], layers.Swish6()),
        ],
        [
            ([5], None, None, 0.25, [96], layers.Swish6()),
            ([5], None, None, 0.25, [88], layers.Swish6()),
            ([5], None, None, 0.25, [80], layers.Swish6()),
            ([5], None, None, 0.25, [72], layers.Swish6()),
            ([5], None, None, 0.25, [68], layers.Swish6()),
            ([5], None, None, 0.25, [64], layers.Swish6()),
            ([5], None, None, 0.25, [60], layers.Swish6()),
            ([5], None, None, 0.25, [56], layers.Swish6()),
            ([5], None, None, 0.25, [48], layers.Swish6()),

            ([3], None, None, 0.25, [96], layers.Swish6()),
            ([3], None, None, 0.25, [88], layers.Swish6()),
            ([3], None, None, 0.25, [80], layers.Swish6()),
            ([3], None, None, 0.25, [72], layers.Swish6()),
            ([3], None, None, 0.25, [68], layers.Swish6()),
            ([3], None, None, 0.25, [64], layers.Swish6()),
            ([3], None, None, 0.25, [60], layers.Swish6()),
            ([3], None, None, 0.25, [56], layers.Swish6()),
            ([3], None, None, 0.25, [48], layers.Swish6()),
        ],
        [
            ([7], None, None, 0.25, [124], layers.Swish6()),
            ([7], None, None, 0.25, [116], layers.Swish6()),
            ([7], None, None, 0.25, [108], layers.Swish6()),
            ([7], None, None, 0.25, [100], layers.Swish6()),
            ([7], None, None, 0.25, [92], layers.Swish6()),
            ([7], None, None, 0.25, [84], layers.Swish6()),
            ([7], None, None, 0.25, [72], layers.Swish6()),
            ([7], None, None, 0.25, [68], layers.Swish6()),
            ([7], None, None, 0.25, [64], layers.Swish6()),
            ([7], None, None, 0.25, [56], layers.Swish6()),
            ([7], None, None, 0.25, [48], layers.Swish6()),

            ([5], None, None, 0.25, [124], layers.Swish6()),
            ([5], None, None, 0.25, [116], layers.Swish6()),
            ([5], None, None, 0.25, [108], layers.Swish6()),
            ([5], None, None, 0.25, [100], layers.Swish6()),
            ([5], None, None, 0.25, [92], layers.Swish6()),
            ([5], None, None, 0.25, [84], layers.Swish6()),
            ([5], None, None, 0.25, [72], layers.Swish6()),
            ([5], None, None, 0.25, [68], layers.Swish6()),
            ([5], None, None, 0.25, [64], layers.Swish6()),
            ([5], None, None, 0.25, [56], layers.Swish6()),
            ([5], None, None, 0.25, [48], layers.Swish6()),

            ([3], None, None, 0.25, [124], layers.Swish6()),
            ([3], None, None, 0.25, [116], layers.Swish6()),
            ([3], None, None, 0.25, [108], layers.Swish6()),
            ([3], None, None, 0.25, [100], layers.Swish6()),
            ([3], None, None, 0.25, [92], layers.Swish6()),
            ([3], None, None, 0.25, [84], layers.Swish6()),
            ([3], None, None, 0.25, [72], layers.Swish6()),
            ([3], None, None, 0.25, [68], layers.Swish6()),
            ([3], None, None, 0.25, [64], layers.Swish6()),
            ([3], None, None, 0.25, [56], layers.Swish6()),
            ([3], None, None, 0.25, [48], layers.Swish6()),
        ],
        [
            ([None], [2, 1, 1], 64, None, [None], layers.Swish6()),
            ([None], [2, 1, 1], 56, None, [None], layers.Swish6()),
            ([None], [2, 1, 1], 52, None, [None], layers.Swish6()),
            ([None], [2, 1, 1], 48, None, [None], layers.Swish6()),
            ([None], [2, 1, 1], 44, None, [None], layers.Swish6()),
            ([None], [2, 1, 1], 40, None, [None], layers.Swish6()),
            ([None], [2, 1, 1], 36, None, [None], layers.Swish6()),
            ([None], [2, 1, 1], 32, None, [None], layers.Swish6()),
            ([None], [2, 1, 1], 24, None, [None], layers.Swish6()),
        ],
        [
            ([7], None, None, 0.25, [128], layers.Swish6()),
            ([7], None, None, 0.25, [120], layers.Swish6()),
            ([7], None, None, 0.25, [112], layers.Swish6()),
            ([7], None, None, 0.25, [104], layers.Swish6()),
            ([7], None, None, 0.25, [96], layers.Swish6()),
            ([7], None, None, 0.25, [88], layers.Swish6()),
            ([7], None, None, 0.25, [80], layers.Swish6()),
            ([7], None, None, 0.25, [76], layers.Swish6()),
            ([7], None, None, 0.25, [72], layers.Swish6()),
            ([7], None, None, 0.25, [64], layers.Swish6()),
            ([7], None, None, 0.25, [56], layers.Swish6()),

            ([5], None, None, 0.25, [128], layers.Swish6()),
            ([5], None, None, 0.25, [120], layers.Swish6()),
            ([5], None, None, 0.25, [112], layers.Swish6()),
            ([5], None, None, 0.25, [104], layers.Swish6()),
            ([5], None, None, 0.25, [96], layers.Swish6()),
            ([5], None, None, 0.25, [88], layers.Swish6()),
            ([5], None, None, 0.25, [80], layers.Swish6()),
            ([5], None, None, 0.25, [76], layers.Swish6()),
            ([5], None, None, 0.25, [72], layers.Swish6()),
            ([5], None, None, 0.25, [64], layers.Swish6()),
            ([5], None, None, 0.25, [56], layers.Swish6()),

            ([3], None, None, 0.25, [128], layers.Swish6()),
            ([3], None, None, 0.25, [120], layers.Swish6()),
            ([3], None, None, 0.25, [112], layers.Swish6()),
            ([3], None, None, 0.25, [104], layers.Swish6()),
            ([3], None, None, 0.25, [96], layers.Swish6()),
            ([3], None, None, 0.25, [88], layers.Swish6()),
            ([3], None, None, 0.25, [80], layers.Swish6()),
            ([3], None, None, 0.25, [76], layers.Swish6()),
            ([3], None, None, 0.25, [72], layers.Swish6()),
            ([3], None, None, 0.25, [64], layers.Swish6()),
            ([3], None, None, 0.25, [56], layers.Swish6()),
        ],
        [
            ([7], None, None, 0.25, [240], layers.Swish6()),
            ([7], None, None, 0.25, [200], layers.Swish6()),
            ([7], None, None, 0.25, [180], layers.Swish6()),
            ([7], None, None, 0.25, [160], layers.Swish6()),
            ([7], None, None, 0.25, [140], layers.Swish6()),
            ([7], None, None, 0.25, [120], layers.Swish6()),
            ([7], None, None, 0.25, [110], layers.Swish6()),
            ([7], None, None, 0.25, [100], layers.Swish6()),
            ([7], None, None, 0.25, [80], layers.Swish6()),

            ([5], None, None, 0.25, [240], layers.Swish6()),
            ([5], None, None, 0.25, [200], layers.Swish6()),
            ([5], None, None, 0.25, [180], layers.Swish6()),
            ([5], None, None, 0.25, [160], layers.Swish6()),
            ([5], None, None, 0.25, [140], layers.Swish6()),
            ([5], None, None, 0.25, [120], layers.Swish6()),
            ([5], None, None, 0.25, [110], layers.Swish6()),
            ([5], None, None, 0.25, [100], layers.Swish6()),
            ([5], None, None, 0.25, [80], layers.Swish6()),

            ([3], None, None, 0.25, [240], layers.Swish6()),
            ([3], None, None, 0.25, [200], layers.Swish6()),
            ([3], None, None, 0.25, [180], layers.Swish6()),
            ([3], None, None, 0.25, [160], layers.Swish6()),
            ([3], None, None, 0.25, [140], layers.Swish6()),
            ([3], None, None, 0.25, [120], layers.Swish6()),
            ([3], None, None, 0.25, [110], layers.Swish6()),
            ([3], None, None, 0.25, [100], layers.Swish6()),
            ([3], None, None, 0.25, [80], layers.Swish6()),
        ],
        [
            ([7], None, None, 0.25, [240], layers.Swish6()),
            ([7], None, None, 0.25, [200], layers.Swish6()),
            ([7], None, None, 0.25, [180], layers.Swish6()),
            ([7], None, None, 0.25, [160], layers.Swish6()),
            ([7], None, None, 0.25, [140], layers.Swish6()),
            ([7], None, None, 0.25, [120], layers.Swish6()),
            ([7], None, None, 0.25, [110], layers.Swish6()),
            ([7], None, None, 0.25, [100], layers.Swish6()),
            ([7], None, None, 0.25, [80], layers.Swish6()),

            ([5], None, None, 0.25, [240], layers.Swish6()),
            ([5], None, None, 0.25, [200], layers.Swish6()),
            ([5], None, None, 0.25, [180], layers.Swish6()),
            ([5], None, None, 0.25, [160], layers.Swish6()),
            ([5], None, None, 0.25, [140], layers.Swish6()),
            ([5], None, None, 0.25, [120], layers.Swish6()),
            ([5], None, None, 0.25, [110], layers.Swish6()),
            ([5], None, None, 0.25, [100], layers.Swish6()),
            ([5], None, None, 0.25, [80], layers.Swish6()),

            ([3], None, None, 0.25, [240], layers.Swish6()),
            ([3], None, None, 0.25, [200], layers.Swish6()),
            ([3], None, None, 0.25, [180], layers.Swish6()),
            ([3], None, None, 0.25, [160], layers.Swish6()),
            ([3], None, None, 0.25, [140], layers.Swish6()),
            ([3], None, None, 0.25, [120], layers.Swish6()),
            ([3], None, None, 0.25, [110], layers.Swish6()),
            ([3], None, None, 0.25, [100], layers.Swish6()),
            ([3], None, None, 0.25, [80], layers.Swish6()),
        ],
        [
            ([None], [2, 1, 1, 1], 160, None, [None], layers.Swish6()),
            ([None], [2, 1, 1, 1], 140, None, [None], layers.Swish6()),
            ([None], [2, 1, 1, 1], 130, None, [None], layers.Swish6()),
            ([None], [2, 1, 1, 1], 120, None, [None], layers.Swish6()),
            ([None], [2, 1, 1, 1], 110, None, [None], layers.Swish6()),
            ([None], [2, 1, 1, 1], 100, None, [None], layers.Swish6()),
            ([None], [2, 1, 1, 1], 80, None, [None], layers.Swish6()),
            ([None], [2, 1, 1, 1], 70, None, [None], layers.Swish6()),
            ([None], [2, 1, 1, 1], 60, None, [None], layers.Swish6()),
        ],
        [
            ([7], None, None, 0.25, [360], layers.Swish6()),
            ([7], None, None, 0.25, [320], layers.Swish6()),
            ([7], None, None, 0.25, [300], layers.Swish6()),
            ([7], None, None, 0.25, [280], layers.Swish6()),
            ([7], None, None, 0.25, [260], layers.Swish6()),
            ([7], None, None, 0.25, [240], layers.Swish6()),
            ([7], None, None, 0.25, [220], layers.Swish6()),
            ([7], None, None, 0.25, [200], layers.Swish6()),
            ([7], None, None, 0.25, [180], layers.Swish6()),
            ([7], None, None, 0.25, [160], layers.Swish6()),

            ([5], None, None, 0.25, [360], layers.Swish6()),
            ([5], None, None, 0.25, [320], layers.Swish6()),
            ([5], None, None, 0.25, [300], layers.Swish6()),
            ([5], None, None, 0.25, [280], layers.Swish6()),
            ([5], None, None, 0.25, [260], layers.Swish6()),
            ([5], None, None, 0.25, [240], layers.Swish6()),
            ([5], None, None, 0.25, [220], layers.Swish6()),
            ([5], None, None, 0.25, [200], layers.Swish6()),
            ([5], None, None, 0.25, [180], layers.Swish6()),
            ([5], None, None, 0.25, [160], layers.Swish6()),

            ([3], None, None, 0.25, [360], layers.Swish6()),
            ([3], None, None, 0.25, [320], layers.Swish6()),
            ([3], None, None, 0.25, [300], layers.Swish6()),
            ([3], None, None, 0.25, [280], layers.Swish6()),
            ([3], None, None, 0.25, [260], layers.Swish6()),
            ([3], None, None, 0.25, [240], layers.Swish6()),
            ([3], None, None, 0.25, [220], layers.Swish6()),
            ([3], None, None, 0.25, [200], layers.Swish6()),
            ([3], None, None, 0.25, [180], layers.Swish6()),
            ([3], None, None, 0.25, [160], layers.Swish6()),
        ],
        [
            ([7], None, None, None, [400], layers.Swish6()),
            ([7], None, None, None, [360], layers.Swish6()),
            ([7], None, None, None, [340], layers.Swish6()),
            ([7], None, None, None, [320], layers.Swish6()),
            ([7], None, None, None, [300], layers.Swish6()),
            ([7], None, None, None, [280], layers.Swish6()),
            ([7], None, None, None, [260], layers.Swish6()),
            ([7], None, None, None, [240], layers.Swish6()),
            ([7], None, None, None, [220], layers.Swish6()),
            ([7], None, None, None, [200], layers.Swish6()),
            ([7], None, None, None, [180], layers.Swish6()),
            ([7], None, None, None, [160], layers.Swish6()),
            ([7], None, None, None, [120], layers.Swish6()),

            ([5], None, None, None, [400], layers.Swish6()),
            ([5], None, None, None, [360], layers.Swish6()),
            ([5], None, None, None, [340], layers.Swish6()),
            ([5], None, None, None, [320], layers.Swish6()),
            ([5], None, None, None, [300], layers.Swish6()),
            ([5], None, None, None, [280], layers.Swish6()),
            ([5], None, None, None, [260], layers.Swish6()),
            ([5], None, None, None, [240], layers.Swish6()),
            ([5], None, None, None, [220], layers.Swish6()),
            ([5], None, None, None, [200], layers.Swish6()),
            ([5], None, None, None, [180], layers.Swish6()),
            ([5], None, None, None, [160], layers.Swish6()),
            ([5], None, None, None, [120], layers.Swish6()),

            ([3], None, None, None, [400], layers.Swish6()),
            ([3], None, None, None, [360], layers.Swish6()),
            ([3], None, None, None, [340], layers.Swish6()),
            ([3], None, None, None, [320], layers.Swish6()),
            ([3], None, None, None, [300], layers.Swish6()),
            ([3], None, None, None, [280], layers.Swish6()),
            ([3], None, None, None, [260], layers.Swish6()),
            ([3], None, None, None, [240], layers.Swish6()),
            ([3], None, None, None, [220], layers.Swish6()),
            ([3], None, None, None, [200], layers.Swish6()),
            ([3], None, None, None, [180], layers.Swish6()),
            ([3], None, None, None, [160], layers.Swish6()),
            ([3], None, None, None, [120], layers.Swish6()),
        ],
        [
            ([7], None, None, None, [368], layers.Swish6()),
            ([7], None, None, None, [336], layers.Swish6()),
            ([7], None, None, None, [304], layers.Swish6()),
            ([7], None, None, None, [288], layers.Swish6()),
            ([7], None, None, None, [272], layers.Swish6()),
            ([7], None, None, None, [256], layers.Swish6()),
            ([7], None, None, None, [240], layers.Swish6()),
            ([7], None, None, None, [224], layers.Swish6()),
            ([7], None, None, None, [208], layers.Swish6()),
            ([7], None, None, None, [184], layers.Swish6()),
            ([7], None, None, None, [168], layers.Swish6()),
            ([7], None, None, None, [152], layers.Swish6()),

            ([5], None, None, None, [368], layers.Swish6()),
            ([5], None, None, None, [336], layers.Swish6()),
            ([5], None, None, None, [304], layers.Swish6()),
            ([5], None, None, None, [288], layers.Swish6()),
            ([5], None, None, None, [272], layers.Swish6()),
            ([5], None, None, None, [256], layers.Swish6()),
            ([5], None, None, None, [240], layers.Swish6()),
            ([5], None, None, None, [224], layers.Swish6()),
            ([5], None, None, None, [208], layers.Swish6()),
            ([5], None, None, None, [184], layers.Swish6()),
            ([5], None, None, None, [168], layers.Swish6()),
            ([5], None, None, None, [152], layers.Swish6()),

            ([3], None, None, None, [368], layers.Swish6()),
            ([3], None, None, None, [336], layers.Swish6()),
            ([3], None, None, None, [304], layers.Swish6()),
            ([3], None, None, None, [288], layers.Swish6()),
            ([3], None, None, None, [272], layers.Swish6()),
            ([3], None, None, None, [256], layers.Swish6()),
            ([3], None, None, None, [240], layers.Swish6()),
            ([3], None, None, None, [224], layers.Swish6()),
            ([3], None, None, None, [208], layers.Swish6()),
            ([3], None, None, None, [184], layers.Swish6()),
            ([3], None, None, None, [168], layers.Swish6()),
            ([3], None, None, None, [152], layers.Swish6()),
        ],
        [
            ([7], None, None, None, [368], layers.Swish6()),
            ([7], None, None, None, [336], layers.Swish6()),
            ([7], None, None, None, [304], layers.Swish6()),
            ([7], None, None, None, [288], layers.Swish6()),
            ([7], None, None, None, [272], layers.Swish6()),
            ([7], None, None, None, [256], layers.Swish6()),
            ([7], None, None, None, [240], layers.Swish6()),
            ([7], None, None, None, [224], layers.Swish6()),
            ([7], None, None, None, [208], layers.Swish6()),
            ([7], None, None, None, [184], layers.Swish6()),
            ([7], None, None, None, [168], layers.Swish6()),
            ([7], None, None, None, [152], layers.Swish6()),

            ([5], None, None, None, [368], layers.Swish6()),
            ([5], None, None, None, [336], layers.Swish6()),
            ([5], None, None, None, [304], layers.Swish6()),
            ([5], None, None, None, [288], layers.Swish6()),
            ([5], None, None, None, [272], layers.Swish6()),
            ([5], None, None, None, [256], layers.Swish6()),
            ([5], None, None, None, [240], layers.Swish6()),
            ([5], None, None, None, [224], layers.Swish6()),
            ([5], None, None, None, [208], layers.Swish6()),
            ([5], None, None, None, [184], layers.Swish6()),
            ([5], None, None, None, [168], layers.Swish6()),
            ([5], None, None, None, [152], layers.Swish6()),

            ([3], None, None, None, [368], layers.Swish6()),
            ([3], None, None, None, [336], layers.Swish6()),
            ([3], None, None, None, [304], layers.Swish6()),
            ([3], None, None, None, [288], layers.Swish6()),
            ([3], None, None, None, [272], layers.Swish6()),
            ([3], None, None, None, [256], layers.Swish6()),
            ([3], None, None, None, [240], layers.Swish6()),
            ([3], None, None, None, [224], layers.Swish6()),
            ([3], None, None, None, [208], layers.Swish6()),
            ([3], None, None, None, [184], layers.Swish6()),
            ([3], None, None, None, [168], layers.Swish6()),
            ([3], None, None, None, [152], layers.Swish6()),
        ],
        [
            ([None], [1, 1], 224, None, [None], layers.Swish6()),
            ([None], [1, 1], 208, None, [None], layers.Swish6()),
            ([None], [1, 1], 192, None, [None], layers.Swish6()),
            ([None], [1, 1], 176, None, [None], layers.Swish6()),
            ([None], [1, 1], 160, None, [None], layers.Swish6()),
            ([None], [1, 1], 144, None, [None], layers.Swish6()),
            ([None], [1, 1], 128, None, [None], layers.Swish6()),
            ([None], [1, 1], 112, None, [None], layers.Swish6()),
            ([None], [1, 1], 96, None, [None], layers.Swish6()),
            ([None], [1, 1], 80, None, [None], layers.Swish6()),
        ],
        [
            ([7], None, None, 0.25, [960], layers.Swish6()),
            ([7], None, None, 0.25, [880], layers.Swish6()),
            ([7], None, None, 0.25, [800], layers.Swish6()),
            ([7], None, None, 0.25, [720], layers.Swish6()),
            ([7], None, None, 0.25, [640], layers.Swish6()),
            ([7], None, None, 0.25, [560], layers.Swish6()),
            ([7], None, None, 0.25, [520], layers.Swish6()),
            ([7], None, None, 0.25, [480], layers.Swish6()),
            ([7], None, None, 0.25, [440], layers.Swish6()),
            ([7], None, None, 0.25, [400], layers.Swish6()),
            ([7], None, None, 0.25, [360], layers.Swish6()),

            ([5], None, None, 0.25, [960], layers.Swish6()),
            ([5], None, None, 0.25, [880], layers.Swish6()),
            ([5], None, None, 0.25, [800], layers.Swish6()),
            ([5], None, None, 0.25, [720], layers.Swish6()),
            ([5], None, None, 0.25, [640], layers.Swish6()),
            ([5], None, None, 0.25, [560], layers.Swish6()),
            ([5], None, None, 0.25, [520], layers.Swish6()),
            ([5], None, None, 0.25, [480], layers.Swish6()),
            ([5], None, None, 0.25, [440], layers.Swish6()),
            ([5], None, None, 0.25, [400], layers.Swish6()),
            ([5], None, None, 0.25, [360], layers.Swish6()),

            ([3], None, None, 0.25, [960], layers.Swish6()),
            ([3], None, None, 0.25, [880], layers.Swish6()),
            ([3], None, None, 0.25, [800], layers.Swish6()),
            ([3], None, None, 0.25, [720], layers.Swish6()),
            ([3], None, None, 0.25, [640], layers.Swish6()),
            ([3], None, None, 0.25, [560], layers.Swish6()),
            ([3], None, None, 0.25, [520], layers.Swish6()),
            ([3], None, None, 0.25, [480], layers.Swish6()),
            ([3], None, None, 0.25, [440], layers.Swish6()),
            ([3], None, None, 0.25, [400], layers.Swish6()),
            ([3], None, None, 0.25, [360], layers.Swish6()),
        ],
        [
            ([7], None, None, 0.25, [1344], layers.Swish6()),
            ([7], None, None, 0.25, [1200], layers.Swish6()),
            ([7], None, None, 0.25, [1056], layers.Swish6()),
            ([7], None, None, 0.25, [960], layers.Swish6()),
            ([7], None, None, 0.25, [888], layers.Swish6()),
            ([7], None, None, 0.25, [816], layers.Swish6()),
            ([7], None, None, 0.25, [768], layers.Swish6()),
            ([7], None, None, 0.25, [720], layers.Swish6()),
            ([7], None, None, 0.25, [624], layers.Swish6()),
            ([7], None, None, 0.25, [576], layers.Swish6()),
            ([7], None, None, 0.25, [480], layers.Swish6()),

            ([5], None, None, 0.25, [1344], layers.Swish6()),
            ([5], None, None, 0.25, [1200], layers.Swish6()),
            ([5], None, None, 0.25, [1056], layers.Swish6()),
            ([5], None, None, 0.25, [960], layers.Swish6()),
            ([5], None, None, 0.25, [888], layers.Swish6()),
            ([5], None, None, 0.25, [816], layers.Swish6()),
            ([5], None, None, 0.25, [768], layers.Swish6()),
            ([5], None, None, 0.25, [720], layers.Swish6()),
            ([5], None, None, 0.25, [624], layers.Swish6()),
            ([5], None, None, 0.25, [576], layers.Swish6()),
            ([5], None, None, 0.25, [480], layers.Swish6()),

            ([3], None, None, 0.25, [1344], layers.Swish6()),
            ([3], None, None, 0.25, [1200], layers.Swish6()),
            ([3], None, None, 0.25, [1056], layers.Swish6()),
            ([3], None, None, 0.25, [960], layers.Swish6()),
            ([3], None, None, 0.25, [888], layers.Swish6()),
            ([3], None, None, 0.25, [816], layers.Swish6()),
            ([3], None, None, 0.25, [768], layers.Swish6()),
            ([3], None, None, 0.25, [720], layers.Swish6()),
            ([3], None, None, 0.25, [624], layers.Swish6()),
            ([3], None, None, 0.25, [576], layers.Swish6()),
            ([3], None, None, 0.25, [480], layers.Swish6()),
        ],
        [
            ([None], [2, 1, 1], 320, None, [None], layers.Swish6()),
            ([None], [2, 1, 1], 280, None, [None], layers.Swish6()),
            ([None], [2, 1, 1], 240, None, [None], layers.Swish6()),
            ([None], [2, 1, 1], 220, None, [None], layers.Swish6()),
            ([None], [2, 1, 1], 200, None, [None], layers.Swish6()),
            ([None], [2, 1, 1], 180, None, [None], layers.Swish6()),
            ([None], [2, 1, 1], 160, None, [None], layers.Swish6()),
            ([None], [2, 1, 1], 120, None, [None], layers.Swish6()),
            ([None], [2, 1, 1], 100, None, [None], layers.Swish6()),
        ],
        [
            ([7], None, None, 0.25, [1344], layers.Swish6()),
            ([7], None, None, 0.25, [1200], layers.Swish6()),
            ([7], None, None, 0.25, [1056], layers.Swish6()),
            ([7], None, None, 0.25, [960], layers.Swish6()),
            ([7], None, None, 0.25, [888], layers.Swish6()),
            ([7], None, None, 0.25, [816], layers.Swish6()),
            ([7], None, None, 0.25, [768], layers.Swish6()),
            ([7], None, None, 0.25, [720], layers.Swish6()),
            ([7], None, None, 0.25, [624], layers.Swish6()),
            ([7], None, None, 0.25, [576], layers.Swish6()),
            ([7], None, None, 0.25, [480], layers.Swish6()),

            ([5], None, None, 0.25, [1344], layers.Swish6()),
            ([5], None, None, 0.25, [1200], layers.Swish6()),
            ([5], None, None, 0.25, [1056], layers.Swish6()),
            ([5], None, None, 0.25, [960], layers.Swish6()),
            ([5], None, None, 0.25, [888], layers.Swish6()),
            ([5], None, None, 0.25, [816], layers.Swish6()),
            ([5], None, None, 0.25, [768], layers.Swish6()),
            ([5], None, None, 0.25, [720], layers.Swish6()),
            ([5], None, None, 0.25, [624], layers.Swish6()),
            ([5], None, None, 0.25, [576], layers.Swish6()),
            ([5], None, None, 0.25, [480], layers.Swish6()),

            ([3], None, None, 0.25, [1344], layers.Swish6()),
            ([3], None, None, 0.25, [1200], layers.Swish6()),
            ([3], None, None, 0.25, [1056], layers.Swish6()),
            ([3], None, None, 0.25, [960], layers.Swish6()),
            ([3], None, None, 0.25, [888], layers.Swish6()),
            ([3], None, None, 0.25, [816], layers.Swish6()),
            ([3], None, None, 0.25, [768], layers.Swish6()),
            ([3], None, None, 0.25, [720], layers.Swish6()),
            ([3], None, None, 0.25, [624], layers.Swish6()),
            ([3], None, None, 0.25, [576], layers.Swish6()),
            ([3], None, None, 0.25, [480], layers.Swish6()),
        ],
        [
            ([7], None, None, 0.25, [1920], layers.Swish6()),
            ([7], None, None, 0.25, [1760], layers.Swish6()),
            ([7], None, None, 0.25, [1600], layers.Swish6()),
            ([7], None, None, 0.25, [1440], layers.Swish6()),
            ([7], None, None, 0.25, [1280], layers.Swish6()),
            ([7], None, None, 0.25, [1120], layers.Swish6()),
            ([7], None, None, 0.25, [960], layers.Swish6()),
            ([7], None, None, 0.25, [880], layers.Swish6()),
            ([7], None, None, 0.25, [800], layers.Swish6()),
            ([7], None, None, 0.25, [720], layers.Swish6()),
            ([7], None, None, 0.25, [640], layers.Swish6()),

            ([5], None, None, 0.25, [1920], layers.Swish6()),
            ([5], None, None, 0.25, [1760], layers.Swish6()),
            ([5], None, None, 0.25, [1600], layers.Swish6()),
            ([5], None, None, 0.25, [1440], layers.Swish6()),
            ([5], None, None, 0.25, [1280], layers.Swish6()),
            ([5], None, None, 0.25, [1120], layers.Swish6()),
            ([5], None, None, 0.25, [960], layers.Swish6()),
            ([5], None, None, 0.25, [880], layers.Swish6()),
            ([5], None, None, 0.25, [800], layers.Swish6()),
            ([5], None, None, 0.25, [720], layers.Swish6()),
            ([5], None, None, 0.25, [640], layers.Swish6()),

            ([3], None, None, 0.25, [1920], layers.Swish6()),
            ([3], None, None, 0.25, [1760], layers.Swish6()),
            ([3], None, None, 0.25, [1600], layers.Swish6()),
            ([3], None, None, 0.25, [1440], layers.Swish6()),
            ([3], None, None, 0.25, [1280], layers.Swish6()),
            ([3], None, None, 0.25, [1120], layers.Swish6()),
            ([3], None, None, 0.25, [960], layers.Swish6()),
            ([3], None, None, 0.25, [880], layers.Swish6()),
            ([3], None, None, 0.25, [800], layers.Swish6()),
            ([3], None, None, 0.25, [720], layers.Swish6()),
            ([3], None, None, 0.25, [640], layers.Swish6()),
        ],
        [
            ([7], None, None, 0.25, [1920], layers.Swish6()),
            ([7], None, None, 0.25, [1760], layers.Swish6()),
            ([7], None, None, 0.25, [1600], layers.Swish6()),
            ([7], None, None, 0.25, [1440], layers.Swish6()),
            ([7], None, None, 0.25, [1280], layers.Swish6()),
            ([7], None, None, 0.25, [1120], layers.Swish6()),
            ([7], None, None, 0.25, [960], layers.Swish6()),
            ([7], None, None, 0.25, [880], layers.Swish6()),
            ([7], None, None, 0.25, [800], layers.Swish6()),
            ([7], None, None, 0.25, [720], layers.Swish6()),
            ([7], None, None, 0.25, [640], layers.Swish6()),

            ([5], None, None, 0.25, [1920], layers.Swish6()),
            ([5], None, None, 0.25, [1760], layers.Swish6()),
            ([5], None, None, 0.25, [1600], layers.Swish6()),
            ([5], None, None, 0.25, [1440], layers.Swish6()),
            ([5], None, None, 0.25, [1280], layers.Swish6()),
            ([5], None, None, 0.25, [1120], layers.Swish6()),
            ([5], None, None, 0.25, [960], layers.Swish6()),
            ([5], None, None, 0.25, [880], layers.Swish6()),
            ([5], None, None, 0.25, [800], layers.Swish6()),
            ([5], None, None, 0.25, [720], layers.Swish6()),
            ([5], None, None, 0.25, [640], layers.Swish6()),

            ([3], None, None, 0.25, [1920], layers.Swish6()),
            ([3], None, None, 0.25, [1760], layers.Swish6()),
            ([3], None, None, 0.25, [1600], layers.Swish6()),
            ([3], None, None, 0.25, [1440], layers.Swish6()),
            ([3], None, None, 0.25, [1280], layers.Swish6()),
            ([3], None, None, 0.25, [1120], layers.Swish6()),
            ([3], None, None, 0.25, [960], layers.Swish6()),
            ([3], None, None, 0.25, [880], layers.Swish6()),
            ([3], None, None, 0.25, [800], layers.Swish6()),
            ([3], None, None, 0.25, [720], layers.Swish6()),
            ([3], None, None, 0.25, [640], layers.Swish6()),
        ],

    ],
}

MOBILENET_V3_STEM_SPEC = [
    # stem_layer, last_stage_before_pooling, last_stage_after_pooling.
    [16, 960, 1440],
    [16, 960, 1280],
]



MAX_MADDS = [
    [(1.81, 4.82, 0.00, 0.00), (1.81, 4.01, 0.00, 0.00), (1.81, 3.61, 0.00, 0.00), (1.81, 3.21, 0.00, 0.00), (1.81, 2.81, 0.00, 0.00)],
[(28.90, 7.53, 10.84, 0.00), (26.49, 6.90, 9.93, 0.00), (24.08, 6.27, 9.03, 0.00), (21.68, 5.64, 8.13, 0.00), (20.47, 5.33, 7.68, 0.00), (19.27, 5.02, 7.23, 0.00), (18.06, 4.70, 6.77, 0.00), (16.86, 4.39, 6.32, 0.00), (14.45, 3.76, 5.42, 0.00), (28.90, 2.71, 10.84, 0.00), (26.49, 2.48, 9.93, 0.00), (24.08, 2.26, 9.03, 0.00), (21.68, 2.03, 8.13, 0.00), (20.47, 1.92, 7.68, 0.00), (19.27, 1.81, 7.23, 0.00), (18.06, 1.69, 6.77, 0.00), (16.86, 1.58, 6.32, 0.00), (14.45, 1.35, 5.42, 0.00)],
[(14.00, 19.05, 14.00, 0.01), (13.10, 17.83, 13.10, 0.01), (12.19, 16.60, 12.19, 0.01), (11.29, 15.37, 11.29, 0.01), (10.39, 14.14, 10.39, 0.00), (9.48, 12.91, 9.48, 0.00), (8.13, 11.06, 8.13, 0.00), (7.68, 10.45, 7.68, 0.00), (7.23, 9.83, 7.23, 0.00), (6.32, 8.61, 6.32, 0.00), (5.42, 7.38, 5.42, 0.00), (14.00, 9.72, 14.00, 0.01), (13.10, 9.09, 13.10, 0.01), (12.19, 8.47, 12.19, 0.01), (11.29, 7.84, 11.29, 0.01), (10.39, 7.21, 10.39, 0.00), (9.48, 6.59, 9.48, 0.00), (8.13, 5.64, 8.13, 0.00), (7.68, 5.33, 7.68, 0.00), (7.23, 5.02, 7.23, 0.00), (6.32, 4.39, 6.32, 0.00), (5.42, 3.76, 5.42, 0.00), (14.00, 3.50, 14.00, 0.01), (13.10, 3.27, 13.10, 0.01), (12.19, 3.05, 12.19, 0.01), (11.29, 2.82, 11.29, 0.01), (10.39, 2.60, 10.39, 0.00), (9.48, 2.37, 9.48, 0.00), (8.13, 2.03, 8.13, 0.00), (7.68, 1.92, 7.68, 0.00), (7.23, 1.81, 7.23, 0.00), (6.32, 1.58, 6.32, 0.00), (5.42, 1.35, 5.42, 0.00)],
[(14.45, 4.92, 6.42, 0.01), (13.55, 4.61, 6.02, 0.01), (12.64, 4.30, 5.62, 0.01), (11.74, 4.00, 5.22, 0.01), (10.84, 3.69, 4.82, 0.00), (9.93, 3.38, 4.42, 0.00), (9.03, 3.07, 4.01, 0.00), (8.58, 2.92, 3.81, 0.00), (8.13, 2.77, 3.61, 0.00), (7.23, 2.46, 3.21, 0.00), (6.32, 2.15, 2.81, 0.00), (14.45, 2.51, 6.42, 0.01), (13.55, 2.35, 6.02, 0.01), (12.64, 2.20, 5.62, 0.01), (11.74, 2.04, 5.22, 0.01), (10.84, 1.88, 4.82, 0.00), (9.93, 1.72, 4.42, 0.00), (9.03, 1.57, 4.01, 0.00), (8.58, 1.49, 3.81, 0.00), (8.13, 1.41, 3.61, 0.00), (7.23, 1.25, 3.21, 0.00), (6.32, 1.10, 2.81, 0.00), (14.45, 0.90, 6.42, 0.01), (13.55, 0.85, 6.02, 0.01), (12.64, 0.79, 5.62, 0.01), (11.74, 0.73, 5.22, 0.01), (10.84, 0.68, 4.82, 0.00), (9.93, 0.62, 4.42, 0.00), (9.03, 0.56, 4.01, 0.00), (8.58, 0.54, 3.81, 0.00), (8.13, 0.51, 3.61, 0.00), (7.23, 0.45, 3.21, 0.00), (6.32, 0.40, 2.81, 0.00)],
[(12.04, 9.22, 12.04, 0.03), (10.04, 7.68, 10.04, 0.02), (9.03, 6.91, 9.03, 0.02), (8.03, 6.15, 8.03, 0.01), (7.02, 5.38, 7.02, 0.01), (6.02, 4.61, 6.02, 0.01), (5.52, 4.23, 5.52, 0.01), (5.02, 3.84, 5.02, 0.01), (4.01, 3.07, 4.01, 0.00), (12.04, 4.70, 12.04, 0.03), (10.04, 3.92, 10.04, 0.02), (9.03, 3.53, 9.03, 0.02), (8.03, 3.14, 8.03, 0.01), (7.02, 2.74, 7.02, 0.01), (6.02, 2.35, 6.02, 0.01), (5.52, 2.16, 5.52, 0.01), (5.02, 1.96, 5.02, 0.01), (4.01, 1.57, 4.01, 0.00), (12.04, 1.69, 12.04, 0.03), (10.04, 1.41, 10.04, 0.02), (9.03, 1.27, 9.03, 0.02), (8.03, 1.13, 8.03, 0.01), (7.02, 0.99, 7.02, 0.01), (6.02, 0.85, 6.02, 0.01), (5.52, 0.78, 5.52, 0.01), (5.02, 0.71, 5.02, 0.01), (4.01, 0.56, 4.01, 0.00)],
[(12.04, 9.22, 12.04, 0.03), (10.04, 7.68, 10.04, 0.02), (9.03, 6.91, 9.03, 0.02), (8.03, 6.15, 8.03, 0.01), (7.02, 5.38, 7.02, 0.01), (6.02, 4.61, 6.02, 0.01), (5.52, 4.23, 5.52, 0.01), (5.02, 3.84, 5.02, 0.01), (4.01, 3.07, 4.01, 0.00), (12.04, 4.70, 12.04, 0.03), (10.04, 3.92, 10.04, 0.02), (9.03, 3.53, 9.03, 0.02), (8.03, 3.14, 8.03, 0.01), (7.02, 2.74, 7.02, 0.01), (6.02, 2.35, 6.02, 0.01), (5.52, 2.16, 5.52, 0.01), (5.02, 1.96, 5.02, 0.01), (4.01, 1.57, 4.01, 0.00), (12.04, 1.69, 12.04, 0.03), (10.04, 1.41, 10.04, 0.02), (9.03, 1.27, 9.03, 0.02), (8.03, 1.13, 8.03, 0.01), (7.02, 0.99, 7.02, 0.01), (6.02, 0.85, 6.02, 0.01), (5.52, 0.78, 5.52, 0.01), (5.02, 0.71, 5.02, 0.01), (4.01, 0.56, 4.01, 0.00)],
[(18.06, 3.46, 11.29, 0.06), (16.06, 3.07, 10.04, 0.05), (15.05, 2.88, 9.41, 0.04), (14.05, 2.69, 8.78, 0.04), (13.05, 2.50, 8.15, 0.03), (12.04, 2.30, 7.53, 0.03), (11.04, 2.11, 6.90, 0.02), (10.04, 1.92, 6.27, 0.02), (9.03, 1.73, 5.64, 0.02), (8.03, 1.54, 5.02, 0.01), (18.06, 1.76, 11.29, 0.06), (16.06, 1.57, 10.04, 0.05), (15.05, 1.47, 9.41, 0.04), (14.05, 1.37, 8.78, 0.04), (13.05, 1.27, 8.15, 0.03), (12.04, 1.18, 7.53, 0.03), (11.04, 1.08, 6.90, 0.02), (10.04, 0.98, 6.27, 0.02), (9.03, 0.88, 5.64, 0.02), (8.03, 0.78, 5.02, 0.01), (18.06, 0.64, 11.29, 0.06), (16.06, 0.56, 10.04, 0.05), (15.05, 0.53, 9.41, 0.04), (14.05, 0.49, 8.78, 0.04), (13.05, 0.46, 8.15, 0.03), (12.04, 0.42, 7.53, 0.03), (11.04, 0.39, 6.90, 0.02), (10.04, 0.35, 6.27, 0.02), (9.03, 0.32, 5.64, 0.02), (8.03, 0.28, 5.02, 0.01)],
[(12.54, 3.84, 12.54, 0.00), (11.29, 3.46, 11.29, 0.00), (10.66, 3.27, 10.66, 0.00), (10.04, 3.07, 10.04, 0.00), (9.41, 2.88, 9.41, 0.00), (8.78, 2.69, 8.78, 0.00), (8.15, 2.50, 8.15, 0.00), (7.53, 2.30, 7.53, 0.00), (6.90, 2.11, 6.90, 0.00), (6.27, 1.92, 6.27, 0.00), (5.64, 1.73, 5.64, 0.00), (5.02, 1.54, 5.02, 0.00), (3.76, 1.15, 3.76, 0.00), (12.54, 1.96, 12.54, 0.00), (11.29, 1.76, 11.29, 0.00), (10.66, 1.67, 10.66, 0.00), (10.04, 1.57, 10.04, 0.00), (9.41, 1.47, 9.41, 0.00), (8.78, 1.37, 8.78, 0.00), (8.15, 1.27, 8.15, 0.00), (7.53, 1.18, 7.53, 0.00), (6.90, 1.08, 6.90, 0.00), (6.27, 0.98, 6.27, 0.00), (5.64, 0.88, 5.64, 0.00), (5.02, 0.78, 5.02, 0.00), (3.76, 0.59, 3.76, 0.00), (12.54, 0.71, 12.54, 0.00), (11.29, 0.64, 11.29, 0.00), (10.66, 0.60, 10.66, 0.00), (10.04, 0.56, 10.04, 0.00), (9.41, 0.53, 9.41, 0.00), (8.78, 0.49, 8.78, 0.00), (8.15, 0.46, 8.15, 0.00), (7.53, 0.42, 7.53, 0.00), (6.90, 0.39, 6.90, 0.00), (6.27, 0.35, 6.27, 0.00), (5.64, 0.32, 5.64, 0.00), (5.02, 0.28, 5.02, 0.00), (3.76, 0.21, 3.76, 0.00)],
[(11.54, 3.53, 11.54, 0.00), (10.54, 3.23, 10.54, 0.00), (9.53, 2.92, 9.53, 0.00), (9.03, 2.77, 9.03, 0.00), (8.53, 2.61, 8.53, 0.00), (8.03, 2.46, 8.03, 0.00), (7.53, 2.30, 7.53, 0.00), (7.02, 2.15, 7.02, 0.00), (6.52, 2.00, 6.52, 0.00), (5.77, 1.77, 5.77, 0.00), (5.27, 1.61, 5.27, 0.00), (4.77, 1.46, 4.77, 0.00), (11.54, 1.80, 11.54, 0.00), (10.54, 1.65, 10.54, 0.00), (9.53, 1.49, 9.53, 0.00), (9.03, 1.41, 9.03, 0.00), (8.53, 1.33, 8.53, 0.00), (8.03, 1.25, 8.03, 0.00), (7.53, 1.18, 7.53, 0.00), (7.02, 1.10, 7.02, 0.00), (6.52, 1.02, 6.52, 0.00), (5.77, 0.90, 5.77, 0.00), (5.27, 0.82, 5.27, 0.00), (4.77, 0.74, 4.77, 0.00), (11.54, 0.65, 11.54, 0.00), (10.54, 0.59, 10.54, 0.00), (9.53, 0.54, 9.53, 0.00), (9.03, 0.51, 9.03, 0.00), (8.53, 0.48, 8.53, 0.00), (8.03, 0.45, 8.03, 0.00), (7.53, 0.42, 7.53, 0.00), (7.02, 0.40, 7.02, 0.00), (6.52, 0.37, 6.52, 0.00), (5.77, 0.32, 5.77, 0.00), (5.27, 0.30, 5.27, 0.00), (4.77, 0.27, 4.77, 0.00)],
[(11.54, 3.53, 11.54, 0.00), (10.54, 3.23, 10.54, 0.00), (9.53, 2.92, 9.53, 0.00), (9.03, 2.77, 9.03, 0.00), (8.53, 2.61, 8.53, 0.00), (8.03, 2.46, 8.03, 0.00), (7.53, 2.30, 7.53, 0.00), (7.02, 2.15, 7.02, 0.00), (6.52, 2.00, 6.52, 0.00), (5.77, 1.77, 5.77, 0.00), (5.27, 1.61, 5.27, 0.00), (4.77, 1.46, 4.77, 0.00), (11.54, 1.80, 11.54, 0.00), (10.54, 1.65, 10.54, 0.00), (9.53, 1.49, 9.53, 0.00), (9.03, 1.41, 9.03, 0.00), (8.53, 1.33, 8.53, 0.00), (8.03, 1.25, 8.03, 0.00), (7.53, 1.18, 7.53, 0.00), (7.02, 1.10, 7.02, 0.00), (6.52, 1.02, 6.52, 0.00), (5.77, 0.90, 5.77, 0.00), (5.27, 0.82, 5.27, 0.00), (4.77, 0.74, 4.77, 0.00), (11.54, 0.65, 11.54, 0.00), (10.54, 0.59, 10.54, 0.00), (9.53, 0.54, 9.53, 0.00), (9.03, 0.51, 9.03, 0.00), (8.53, 0.48, 8.53, 0.00), (8.03, 0.45, 8.03, 0.00), (7.53, 0.42, 7.53, 0.00), (7.02, 0.40, 7.02, 0.00), (6.52, 0.37, 6.52, 0.00), (5.77, 0.32, 5.77, 0.00), (5.27, 0.30, 5.27, 0.00), (4.77, 0.27, 4.77, 0.00)],
    [(30.11, 9.22, 42.15, 0.46), (27.60, 8.45, 38.64, 0.39), (25.09, 7.68, 35.12, 0.32), (22.58, 6.91, 31.61, 0.26), (20.07, 6.15, 28.10, 0.20), (17.56, 5.38, 24.59, 0.16), (16.31, 4.99, 22.83, 0.14), (15.05, 4.61, 21.07, 0.12), (13.80, 4.23, 19.32, 0.10), (12.54, 3.84, 17.56, 0.08), (11.29, 3.46, 15.81, 0.06), (30.11, 4.70, 42.15, 0.46), (27.60, 4.31, 38.64, 0.39), (25.09, 3.92, 35.12, 0.32), (22.58, 3.53, 31.61, 0.26), (20.07, 3.14, 28.10, 0.20), (17.56, 2.74, 24.59, 0.16), (16.31, 2.55, 22.83, 0.14), (15.05, 2.35, 21.07, 0.12), (13.80, 2.16, 19.32, 0.10), (12.54, 1.96, 17.56, 0.08), (11.29, 1.76, 15.81, 0.06), (30.11, 1.69, 42.15, 0.46), (27.60, 1.55, 38.64, 0.39), (25.09, 1.41, 35.12, 0.32), (22.58, 1.27, 31.61, 0.26), (20.07, 1.13, 28.10, 0.20), (17.56, 0.99, 24.59, 0.16), (16.31, 0.92, 22.83, 0.14), (15.05, 0.85, 21.07, 0.12), (13.80, 0.78, 19.32, 0.10), (12.54, 0.71, 17.56, 0.08), (11.29, 0.64, 15.81, 0.06)],
[(59.01, 12.91, 59.01, 0.90), (52.68, 11.52, 52.68, 0.72), (46.36, 10.14, 46.36, 0.56), (42.15, 9.22, 42.15, 0.46), (38.99, 8.53, 38.99, 0.39), (35.83, 7.84, 35.83, 0.33), (33.72, 7.38, 33.72, 0.29), (31.61, 6.91, 31.61, 0.26), (27.40, 5.99, 27.40, 0.19), (25.29, 5.53, 25.29, 0.17), (21.07, 4.61, 21.07, 0.12), (59.01, 6.59, 59.01, 0.90), (52.68, 5.88, 52.68, 0.72), (46.36, 5.17, 46.36, 0.56), (42.15, 4.70, 42.15, 0.46), (38.99, 4.35, 38.99, 0.39), (35.83, 4.00, 35.83, 0.33), (33.72, 3.76, 33.72, 0.29), (31.61, 3.53, 31.61, 0.26), (27.40, 3.06, 27.40, 0.19), (25.29, 2.82, 25.29, 0.17), (21.07, 2.35, 21.07, 0.12), (59.01, 2.37, 59.01, 0.90), (52.68, 2.12, 52.68, 0.72), (46.36, 1.86, 46.36, 0.56), (42.15, 1.69, 42.15, 0.46), (38.99, 1.57, 38.99, 0.39), (35.83, 1.44, 35.83, 0.33), (33.72, 1.35, 33.72, 0.29), (31.61, 1.27, 31.61, 0.26), (27.40, 1.10, 27.40, 0.19), (25.29, 1.02, 25.29, 0.17), (21.07, 0.85, 21.07, 0.12)],
[(59.01, 3.23, 21.07, 0.90), (52.68, 2.88, 18.82, 0.72), (46.36, 2.54, 16.56, 0.56), (42.15, 2.30, 15.05, 0.46), (38.99, 2.13, 13.92, 0.39), (35.83, 1.96, 12.79, 0.33), (33.72, 1.84, 12.04, 0.29), (31.61, 1.73, 11.29, 0.26), (27.40, 1.50, 9.78, 0.19), (25.29, 1.38, 9.03, 0.17), (21.07, 1.15, 7.53, 0.12), (59.01, 1.65, 21.07, 0.90), (52.68, 1.47, 18.82, 0.72), (46.36, 1.29, 16.56, 0.56), (42.15, 1.18, 15.05, 0.46), (38.99, 1.09, 13.92, 0.39), (35.83, 1.00, 12.79, 0.33), (33.72, 0.94, 12.04, 0.29), (31.61, 0.88, 11.29, 0.26), (27.40, 0.76, 9.78, 0.19), (25.29, 0.71, 9.03, 0.17), (21.07, 0.59, 7.53, 0.12), (59.01, 0.59, 21.07, 0.90), (52.68, 0.53, 18.82, 0.72), (46.36, 0.47, 16.56, 0.56), (42.15, 0.42, 15.05, 0.46), (38.99, 0.39, 13.92, 0.39), (35.83, 0.36, 12.79, 0.33), (33.72, 0.34, 12.04, 0.29), (31.61, 0.32, 11.29, 0.26), (27.40, 0.28, 9.78, 0.19), (25.29, 0.25, 9.03, 0.17), (21.07, 0.21, 7.53, 0.12)],
[(30.11, 4.61, 30.11, 1.84), (27.60, 4.23, 27.60, 1.55), (25.09, 3.84, 25.09, 1.28), (22.58, 3.46, 22.58, 1.04), (20.07, 3.07, 20.07, 0.82), (17.56, 2.69, 17.56, 0.63), (15.05, 2.30, 15.05, 0.46), (13.80, 2.11, 13.80, 0.39), (12.54, 1.92, 12.54, 0.32), (11.29, 1.73, 11.29, 0.26), (10.04, 1.54, 10.04, 0.20), (30.11, 2.35, 30.11, 1.84), (27.60, 2.16, 27.60, 1.55), (25.09, 1.96, 25.09, 1.28), (22.58, 1.76, 22.58, 1.04), (20.07, 1.57, 20.07, 0.82), (17.56, 1.37, 17.56, 0.63), (15.05, 1.18, 15.05, 0.46), (13.80, 1.08, 13.80, 0.39), (12.54, 0.98, 12.54, 0.32), (11.29, 0.88, 11.29, 0.26), (10.04, 0.78, 10.04, 0.20), (30.11, 0.85, 30.11, 1.84), (27.60, 0.78, 27.60, 1.55), (25.09, 0.71, 25.09, 1.28), (22.58, 0.64, 22.58, 1.04), (20.07, 0.56, 20.07, 0.82), (17.56, 0.49, 17.56, 0.63), (15.05, 0.42, 15.05, 0.46), (13.80, 0.39, 13.80, 0.39), (12.54, 0.35, 12.54, 0.32), (11.29, 0.32, 11.29, 0.26), (10.04, 0.28, 10.04, 0.20)],
[(30.11, 4.61, 30.11, 1.84), (27.60, 4.23, 27.60, 1.55), (25.09, 3.84, 25.09, 1.28), (22.58, 3.46, 22.58, 1.04), (20.07, 3.07, 20.07, 0.82), (17.56, 2.69, 17.56, 0.63), (15.05, 2.30, 15.05, 0.46), (13.80, 2.11, 13.80, 0.39), (12.54, 1.92, 12.54, 0.32), (11.29, 1.73, 11.29, 0.26), (10.04, 1.54, 10.04, 0.20), (30.11, 2.35, 30.11, 1.84), (27.60, 2.16, 27.60, 1.55), (25.09, 1.96, 25.09, 1.28), (22.58, 1.76, 22.58, 1.04), (20.07, 1.57, 20.07, 0.82), (17.56, 1.37, 17.56, 0.63), (15.05, 1.18, 15.05, 0.46), (13.80, 1.08, 13.80, 0.39), (12.54, 0.98, 12.54, 0.32), (11.29, 0.88, 11.29, 0.26), (10.04, 0.78, 10.04, 0.20), (30.11, 0.85, 30.11, 1.84), (27.60, 0.78, 27.60, 1.55), (25.09, 0.71, 25.09, 1.28), (22.58, 0.64, 22.58, 1.04), (20.07, 0.56, 20.07, 0.82), (17.56, 0.49, 17.56, 0.63), (15.05, 0.42, 15.05, 0.46), (13.80, 0.39, 13.80, 0.39), (12.54, 0.35, 12.54, 0.32), (11.29, 0.32, 11.29, 0.26), (10.04, 0.28, 10.04, 0.20)],
[(15.05, 1.38, 1.44), (15.05, 1.23, 1.28)],
]


# Group id to DNA index with filter
GROUP_TO_SPEC_ID = [0, 1, 4, 8, 13, 16, 20]

# DNA index to group id
INDEX_TO_GROUP = [0, 1, 1, 1, 2, 2, 2, 2, 3, 3, 3, 3, 3, 4, 4, 4, 5, 5, 5, 5, 6]

# Layer id to group id
LAYER_TO_GROUP = [0, 1, 1, 2, 2, 2, 3, 3, 3, 3, 4, 4, 5, 5, 5, 6]

# DNA index to layer id
LAYER_ID = [0, 1, 2, 2, 3, 4, 5, 5, 6, 7, 8, 9, 9, 10, 11, 11, 12, 13, 14, 14, 15]

# Layer id to DNA id
LAYER_TO_DNA_ID = [0, 1, 2, 4, 5, 6, 8, 9, 10, 11, 13, 14, 16, 17, 18, 20]


SPEC_TO_DNA_ID = [0, 3, 1, 2, 7, 4, 5, 6, 12, 8, 9, 10, 11, 15, 13, 14, 19, 16, 17, 18, 20]

DNA_TO_SPEC_ID = [0, 2, 3, 1, 5, 6, 7, 4, 9, 10, 11, 12, 8, 14, 15, 13, 17, 18, 19, 16, 20]



LAST_FILTER = 16
INIT_COST=5.42

def _madd(dna: List[int]):
  cost = INIT_COST
  last_filter = -1
  for i in range(0, len(LAYER_TO_DNA_ID)):
    dna_id = LAYER_TO_DNA_ID[i]

    if i == 0:
      last_filter = LAST_FILTER
      base_filter = SEARCH_SPEC['value'][0][0][2]
      cur_filter = SEARCH_SPEC['value'][0][dna[0]][2]
      a = MAX_MADDS[0][dna[0]][1]
      b = MAX_MADDS[0][dna[0]][0]
      cost += a + b
    elif i < 15:
      if LAYER_TO_GROUP[i-1] != LAYER_TO_GROUP[i]:
        filter_index = GROUP_TO_SPEC_ID[LAYER_TO_GROUP[i] - 1]
      else:
        filter_index = GROUP_TO_SPEC_ID[LAYER_TO_GROUP[i]]
      filter_spec = SEARCH_SPEC['value'][filter_index]
      last_filter = filter_spec[dna[SPEC_TO_DNA_ID[filter_index]]][2]
      base_filter = filter_spec[0][2]

      a = MAX_MADDS[i][dna[dna_id]][0] / base_filter * last_filter
      b = MAX_MADDS[i][dna[dna_id]][1]
      d = MAX_MADDS[i][dna[dna_id]][3]

      filter_index = GROUP_TO_SPEC_ID[LAYER_TO_GROUP[i]]
      filter_spec = SEARCH_SPEC['value'][filter_index]
      cur_filter = filter_spec[dna[SPEC_TO_DNA_ID[filter_index]]][2]
      base_filter = filter_spec[0][2]
      c = MAX_MADDS[i][dna[dna_id]][2] / base_filter * cur_filter
      cost += a+b+c+d
    else:
      filter_index = GROUP_TO_SPEC_ID[LAYER_TO_GROUP[i] - 1]
      filter_spec = SEARCH_SPEC['value'][filter_index]
      last_filter = filter_spec[dna[SPEC_TO_DNA_ID[filter_index]]][2]
      base_filter = filter_spec[0][2]
      a = MAX_MADDS[i][dna[dna_id]][0] / base_filter * last_filter
      b = MAX_MADDS[i][dna[dna_id]][1]
      c = MAX_MADDS[i][dna[dna_id]][2]
      cost += a + b + c
      last_spec = SEARCH_SPEC['value'][-1]
  return cost




CALC_MADD = 'mbv2:CALC_MADD'
@layer_nas.Registry.register_filter_fn(CALC_MADD)
def calc_madd(proposal: layer_nas.Proposal,
              search_order: List[int],
              cost: List[List[float]],
              target_cost_min: float,
              target_cost_max: float) -> bool:
  """Calculates the FLOPs to see if descendants of the proposal will be in range."""
  search_id = proposal.get_search_id()
  dna = proposal.dna.to_numbers()

  cost = proposal.get_cost()
  if not cost:
    cost = INIT_COST # Initial Conv2D with filter=16
    start_id = 0
  else:
    cost = cost / 2e6
    start_id = search_id

  if search_id == 0:
    return True

  max_cost = _madd(dna)

  for i in range(search_id + 1, len(dna) - 1):
    dna[SPEC_TO_DNA_ID[i]] = len(SEARCH_SPEC['value'][i]) - 1
  dna[-1] = len(MOBILENET_V3_STEM_SPEC) -1
  min_cost = _madd(dna)

  logging.info("LAYERNAS: cost range for %s: %f, %f",
               proposal.get_dna_str(), min_cost, max_cost)
  return max_cost >= target_cost_min and min_cost <= target_cost_max


def layernas_mobilenet(
    cost_min: float = 220,
    cost_max: float = 240,
    num_search_per_layer: int = 1,
    num_children_per_search: int = 1,
    num_sample_per_search: int = 3,
    fill_all_rows: bool = True) -> pg.DNAGenerator:
  """Returns the algorithm for MobileNet."""
  init_proposals = [
      [0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
      [1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
      [2, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
      [3, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
      [4, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
      [0, 0, 0, 5, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
      [1, 0, 0, 4, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
      [2, 0, 0, 3, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
      [3, 0, 0, 2, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
      [4, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],

  ]

  SEARCH_ORDER = SPEC_TO_DNA_ID
  CHOICES = [0] * len(SEARCH_ORDER)
  for spec_id, dna_id in enumerate(SEARCH_ORDER[:-1]):
    CHOICES[dna_id] = len(SEARCH_SPEC['value'][spec_id])
  CHOICES[-1] = len(MOBILENET_V3_STEM_SPEC)

  return layer_nas.LayerNAS(
      num_choice=CHOICES,
      target_cost_min=cost_min,
      target_cost_max=cost_max,
      init_dna=init_proposals,
      filter_fn_name=CALC_MADD,
      search_order=SEARCH_ORDER,
      bucket_fn_name=layer_nas.COST_BUCKET_NAME,
      fill_all_rows=False,
      num_search_per_layer=num_search_per_layer,
      num_children_per_search=num_children_per_search,
      num_sample_per_search=num_sample_per_search)

