#!/bin/bash

echo "Starting tmux sessions for the 3d quadrotor hyperparameter tuning..."

echo "Starting baseline..."
tmux new-session -d -s o_3dquad_base "source activate action_masking; python3 action_masking/experiments/benchmark_3d_quadrotor.py --approach=baseline --optimize"

for mm in "generator" "ray" "distribution"
do
    echo "Starting o_3dquad_$mm..."
    tmux new-session -d -s o_3dquad_$mm "source activate action_masking; python3 action_masking/experiments/benchmark_3d_quadrotor.py --approach=masking --masking-mode=$mm --optimize"
done