# FuncGenFoil: Airfoil Generation and Editing Model in Function Space

**FuncGenFoil**, short for Function-Space Generated Airfoil, is a method for generating airfoils using generative models in function space, such as diffusion models or flow models. This library provides a framework to demonstrate the power of generative models in design and optimization.

## Outline

- [FuncGenFoil: Airfoil Generation and Editing Model in Function Space](#funcgenfoil-airfoil-generation-and-editing-model-in-function-space)
  - [Outline](#outline)
  - [Framework](#framework)
  - [Installation](#installation)
  - [Demo](#demo)
  - [Quick Start](#quick-start)
  - [Citation](#citation)
  - [License](#license)

## Framework

Demonstration of airfoil generation model training and inference in function space.
<p align="center">
  <img src="assets/airfoil_generation.png" alt="airfoil generation model training and inference" width="100%" height="auto" style="margin: 0 1%;">
</p>

Demonstration of airfoil editing model training and inference in function space.
<p align="center">
  <img src="assets/airfoil_editing.png" alt="airfoil editing model training and inference" width="100%" height="auto" style="margin: 0 1%;">
</p>

## Installation

Please install from source:

```bash
cd FuncGenFoil
pip install -e .
pip install accelerate
```

## Demo
You can evaluate airfoil generation and editing using the model we provided, which is trained on the supercritical dataset.
You can download the model from [here](https://www.dropbox.com/scl/fo/iyuz2ny9srkzttxhq2kkt/AOhJtbbX_zbIHdO7KarS-7c?rlkey=i5ixx1loqrqvqm2uz6rupnqrm&st=edn8np20&dl=0) and save it in the current directory.

To evaluate airfoil generation and editing using Gradio:
```bash
pip install gradio
python app.py
```

## Quick Start

Here is an example of how to train a airfoil generative flow model in function space.

Download dataset from [here](https://drive.google.com/drive/folders/1LU6p-TeWpH5b1Vvh2GRv_TwetHkyV8jZ?usp=sharing) and save it in the current directory.

To train the model without conditional information:
```bash
python examples/train_unconditional_airfoil_generation.py
```

To train the model with conditional information:
```bash
python examples/train_conditional_airfoil_generation.py
```

To train the model for airfoil editing:
```bash
python examples/train_airfoil_editing.py
```

To evaluate the model for airfoil generation:
```bash
python examples/eval_airfoil_editing.py
```

To evaluate the model for airfoil generation with super-resolution:
```bash
python examples/eval_airfoil_generation_super_resolution.py
```



## License

FuncGenFoil is licensed under the Apache License 2.0. See [LICENSE](LICENSE) for more details.
