# LatentKeypointGAN

## Installation

This code requires PyTorch 1.9 and python 3+. Please install dependencies by

```bash
pip install -r requirements.txt
```

This code also requires the [Synchronized-BatchNorm-PyTorch rep](https://github.com/vacancy/Synchronized-BatchNorm-PyTorch), which we already put in `./model`.

## Training KeypointGAN
Run

```bash
python trian.py --model [your_model_file_name] --dis_model [your_discriminator_file_name] --data_root [path_to_dataset] --class_name [ffhq_or_celeba] --z_dim [the_input_noise_dimension] --n_keypoints [number_of_keypoints] --tau [keypoint_size] --n_embedding [the_keypoint_embedding_dimension]
```

The trained model checkpoints, hyper parameters, Tensorboard logs, and the evaluation images (after every epoch) will be saved in `./log/[model]_[dis_model]_k[n_keypoints]_tau[tau]_[class_name]/`.

## Testing KeypointGAN

Put the to-be-tested checkpoints `epoch_x.model` to the folder `./log/[logs_path]/checkpoints` and put the hyper parameter file `parameters.json` to `./log/[logs_path]/`. Note that if you have already trained the to-be-tested models in the same machine, and did not move any files, then the checkpoints and the hyper parameter file are already in the right location. 

After the files are put in the right location, you can run `test.ipynb` in Jupyter Notebook to test.

## Training Detection Networks

To train the detection network, run

```bash
python train_celeba_detection_pro.py --model [your_detection_model_file_name] --generator_log [logs_path_of_trained_KeypointGAN] --data_root [path_to_dataset]
```

The trained detector model checkpoints, hyper parameters, Tensorboard logs, and the evaluation images (with the regressed landmarks) will be saved in `./logs/[model]_[generator_model]_k[n_keypoints]_[class_name]`.
