# ML Governance Games

## Development 
This project uses [Poetry](https://python-poetry.org) for dependency management. To start developing, first [install `poetry`](https://python-poetry.org/docs/master/#installing-with-the-official-installer) then:

```
>> cd .
>> poetry install
```

Poetry will install all dependencies and create an appropriate virtual environment for the project. To get started with a notebook server: 

```
>> poetry run jupyter lab
```

Otherwise, to run python scripts in the environment:
```
>> poetry run python <script>.py
```

For example:
```
>> poetry run bash game_dynamics/utkface_experiment.sh
```

To get the location of the environment:
```
>> poetry run which python
/Users//Library/Caches/pypoetry/virtualenvs/governance-games-S7sOSjaR-py3.9/bin/python
```

### Running Tests
```
poetry run python -m  pytest tests/test_jax_nonjax.py --rootdir="."
```
