#!/bin/bash
#SBATCH --array=0
#SBATCH --mem=40GB
#SBATCH --output=%j.out
#SBATCH --error=%j.err
#SBATCH --qos=nic
#SBATCH --gres=gpu:1
#SBATCH -A nic
#SBATCH -c 4
#SBATCH --partition=nic

# source /mfsnic/projects/fairPATE/impartiality_env/bin/activate
EROOT="/h/321/$1/governance-games"
RROOT="/mfsnic/u/$2/gg"

poetry run python $EROOT/experiment.py \
    --experiment_name "celeba_RQ1_regulators" \
    --prev_results_dir $EROOT/game_dynamics/previous_results/ \
    --save_path $EROOT/game_dynamics/results/ \
    --path $RROOT/ \
    --data_dir /mfsnic/datasets/ \
    --num_rounds 20 \
    --init_priv 1 \
    --init_fair 0.15 \
    --step_size_decay 1.5 \
    --dataset 'celebasensitive' \
    --priority 'builder' \
    --step_size_priv 100 \
    --step_size_fair 20 \
    --builder_lambda 0.7
