#!/bin/bash
#SBATCH --array=0
#SBATCH --mem=40GB
#SBATCH --output=%j.out
#SBATCH --error=%j.err
#SBATCH --qos=nic
#SBATCH --gres=gpu:1
#SBATCH -A nic
#SBATCH -c 4
#SBATCH --partition=nic

# source /mfsnic/projects/fairPATE/impartiality_env/bin/activate
EROOT="/h/321/$1/governance-games"
RROOT="/mfsnic/u/$2/gg"

poetry run python $EROOT/experiment.py \
    --experiment_name "mnist_test" \
    --algorithm 'fairdp' \
    --prev_results_dir $EROOT/game_dynamics/previous_results/ \
    --save_path $EROOT/game_dynamics/results/ \
    --path $RROOT/ \
    --data_dir /mfsnic/datasets/ \
    --num_rounds 20 \
    --init_priv 0 \
    --init_fair 0 \
    --dataset 'mnist' \
    --priority 'regulators' \
    --step_size_priv 5 \
    --step_size_fair 2 \
    --step_size_decay 1.5 \
    --builder_lambda 0.7 \
    --lambda_priv 0.3 \
    --lambda_fair 0.3 \
    --C_priv 5 \
    --C_fair 3 \
    --goal_priv 4 \
    --goal_fair 0.4 \
    --penalty_decay_priv 1.2 \
    --penalty_decay_fair 1.2 \
    --calibration 0
