# Code Module

This directory contains the source code for the template reasoning system.

## Directory Structure

### core/
Contains the core functionality for template reasoning and processing:
- Pipeline implementations for beam search template reasoning
- Template dictionaries and configurations
- DPO (Direct Preference Optimization) scoring systems

### data_process/
Contains utilities for data processing and preparation:
- DPO training data construction
- Data clustering and sampling methods
- Training dataset management

### evaluation/
Contains evaluation tools for template performance assessment:
- Template comparison utilities
- Performance metrics and analysis
- Baseline comparison tools

### utils/
Contains utility functions and helper classes:
- ODPS integration utilities
- Infrastructure support functions
- System integration tools

## Usage

Each module provides specific functionality for different aspects of the template reasoning system. Refer to individual module README files for detailed usage instructions.