TEST_SAMPLES = [
    {"id": "Mercury_SC_408040", "context": "sent1: if an object / something is in the sunlight then that object / that something will absorb solar energy sent2: daylight is when the sun shines on a location sent3: the northern hemisphere is a kind of hemisphere of earth sent4: when the season changes , the amount of daylight will change sent5: intensity of sunlight is similar to amount of sunlight sent6: as the distance of a location from the north pole becomes smaller / closer , the amount of daylight received by that location will increase during the summer sent7: receiving sunlight is synonymous with absorbing sunlight sent8: a hemisphere is a part of earth sent9: sunlight means solar energy sent10: the earth being tilted on its rotating axis causes seasons sent11: as the latitude of a location decreases , the amount of sunlight in this location will increase sent12: being in the sun is synonymous with being in the sunlight sent13: days are a kind of unit for measuring time sent14: sunshine means sunlight sent15: if a place is in summer, then it will have the most sunlight sent16: amount of daylight means length of daylight sent17: daytime means day sent18: to receive sunlight means to absorb sunlight sent19: hours are a kind of unit for measuring time sent20: sunlight shining means sunlight is provided sent21: a hemisphere of earth is a kind of place sent22: daylight hours means time during which there is daylight sent23: if places are receiving the same amount of sunlight , then these places will have similar seasonal weather pattern sent24: period of daylight is synonymous with amount of daylight sent25: daylight means sunlight", "question": "Melinda learned that days in some seasons have more daylight hours than in other seasons. Which season receives the most hours of sunlight in the Northern Hemisphere?", "answer": "summer", "hypothesis": "northern hemisphere will have the most sunlight in summer", "proof": "sent21 & sent3 -> int1: the northern hemisphere is a kind of place; int1 & sent15 -> hypothesis; ", "full_text_proof": " [BECAUSE] a hemisphere of earth is a kind of place [AND] the northern hemisphere is a kind of hemisphere of earth [INFER] int1: the northern hemisphere is a kind of place [BECAUSE] int1 [AND] if a place is in summer, then it will have the most sunlight [INFER] int2: northern hemisphere will have the most sunlight in summer", "depth_of_proof": 2, "length_of_proof": 2, "meta": {"question_text": "Melinda learned that days in some seasons have more daylight hours than in other seasons. Which season receives the most hours of sunlight in the Northern Hemisphere?", "answer_text": "summer", "hypothesis_id": "int2", "triples": {"sent1": "if an object / something is in the sunlight then that object / that something will absorb solar energy", "sent2": "daylight is when the sun shines on a location", "sent3": "the northern hemisphere is a kind of hemisphere of earth", "sent4": "when the season changes , the amount of daylight will change", "sent5": "intensity of sunlight is similar to amount of sunlight", "sent6": "as the distance of a location from the north pole becomes smaller / closer , the amount of daylight received by that location will increase during the summer", "sent7": "receiving sunlight is synonymous with absorbing sunlight", "sent8": "a hemisphere is a part of earth", "sent9": "sunlight means solar energy", "sent10": "the earth being tilted on its rotating axis causes seasons", "sent11": "as the latitude of a location decreases , the amount of sunlight in this location will increase", "sent12": "being in the sun is synonymous with being in the sunlight", "sent13": "days are a kind of unit for measuring time", "sent14": "sunshine means sunlight", "sent15": "if a place is in summer, then it will have the most sunlight", "sent16": "amount of daylight means length of daylight", "sent17": "daytime means day", "sent18": "to receive sunlight means to absorb sunlight", "sent19": "hours are a kind of unit for measuring time", "sent20": "sunlight shining means sunlight is provided", "sent21": "a hemisphere of earth is a kind of place", "sent22": "daylight hours means time during which there is daylight", "sent23": "if places are receiving the same amount of sunlight , then these places will have similar seasonal weather pattern", "sent24": "period of daylight is synonymous with amount of daylight", "sent25": "daylight means sunlight"}, "distractors": ["sent6", "sent4", "sent24", "sent16", "sent25", "sent7", "sent8", "sent22", "sent2", "sent18", "sent20", "sent9", "sent14", "sent23", "sent12", "sent5", "sent19", "sent1", "sent17", "sent10", "sent13", "sent11"], "distractors_relevance": [5.264254, 4.324905, -0.1783734, -5.627389, -5.892709, -8.908398, -9.134111, -9.938904, -11.398458, -11.63155, -11.99802, -12.7248, -14.403854, -14.829711, -14.946836, -15.592381, -16.117653, -16.791107, -17.383549, -17.398407, -17.60524, -17.817303], "intermediate_conclusions": {"int1": "the northern hemisphere is a kind of place", "int2": "northern hemisphere will have the most sunlight in summer"}, "core_concepts": ["if a place is in summer, then it will have the most sunlight"], "step_proof": "sent21 & sent3 -> int1: the northern hemisphere is a kind of place; int1 & sent15 -> hypothesis; ", "lisp_proof": "((((sent21 sent3) -> int1) sent15) -> int2)", "polish_proof": "# int2 & # int1 & sent21 sent3 sent15", "worldtree_provenance": {"sent1": {"uuid": "8745-b081-65b5-bc99", "original_text": "the northern hemisphere is a kind of hemisphere of earth"}, "sent2": {"uuid": "564e-eb72-a12b-dbaa", "original_text": "summer has the most sunlight"}, "sent3": {"uuid": "", "original_text": "a hemisphere of earth is a kind of place"}}, "add_list": [{"sid": "sent3", "fact": "a hemisphere of earth is a kind of place"}], "delete_list": [{"uuid": "3d48-ef4c-bf06-a0c5", "fact": "the amount of daylight is greatest in the summer"}, {"uuid": "1181-3098-4bab-9d92", "fact": "when a hemisphere is tilted towards the sun , that hemisphere receives more direct sunlight"}, {"uuid": "5949-8ca0-0ddf-811b", "fact": "summer is when a hemisphere is tilted towards the sun"}, {"uuid": "27ac-0696-3449-6bd2", "fact": "when the seasons change from summer to fall / from summer to winter , the amount of daylight will decrease"}, {"uuid": "c354-58fd-8d25-d949", "fact": "daylight occurs during the day"}, {"uuid": "3f3f-f2cb-ae3d-f238", "fact": "summer is a kind of season"}, {"uuid": "624a-c1ec-8c85-45ce", "fact": "amount is a property of something and includes ordered values of none / least / little / some / half / much / many / most / all"}, {"uuid": "a538-175f-9223-d117", "fact": "the sun is a source of light / light energy called sunlight"}, {"uuid": "edf4-85da-9b93-a962", "fact": "every summer is a kind of period of time"}, {"uuid": "1ed3-919d-4a4c-1be7", "fact": "the sun is the source of solar energy called sunlight"}, {"uuid": "bfdf-b468-ee22-1b60", "fact": "an increase is the opposite of a decrease"}, {"uuid": "7b97-d2e2-7317-c84c", "fact": "the winter in the southern hemisphere is during the summer in the northern hemisphere"}, {"uuid": "a6b9-8323-ab01-cfe7", "fact": "summer has hot temperatures / weather"}, {"uuid": "5510-64d4-c9fc-9719", "fact": "the winter in the northern hemisphere is during the summer in the southern hemisphere"}, {"uuid": "633c-3fd4-7320-00cf", "fact": "winter is a kind of season"}, {"uuid": "b695-f668-1dec-659c", "fact": "the amount of daylight is least in the winter"}, {"uuid": "9fc2-699f-7287-fc0d", "fact": "winter is the opposite of summer"}, {"uuid": "49dc-4526-46f9-5b32", "fact": "sunlight is a kind of light"}, {"uuid": "551a-ecdb-38e6-4b09", "fact": "the amount of daylight is greatest on the summer solstice"}, {"uuid": "842e-1407-d27c-3e94", "fact": "greatest means largest / highest / most amount of something"}, {"uuid": "9d81-1044-ea43-b59c", "fact": "if two or more things are in a relationship then those things impact each other"}, {"uuid": "2f53-db43-c6e9-95bc", "fact": "greater means higher / more in value"}, {"uuid": "c12d-b29a-5073-54ab", "fact": "if something is outside during the day then that something will receive sunlight"}, {"uuid": "794f-a751-b0d2-097f", "fact": "a sunny day has lots of sunlight"}]}},
    {"id": "NYSEDREGENTS_2014_4_2", "context": "sent1: the earth revolves around the sun sent2: a complete revolution / orbit of a planet around its star takes 1 / one planetary year sent3: planets in the solar system orbit the sun sent4: 1 month is equal to 28-31 days sent5: revolving around something means orbiting that something sent6: a celestial body travelling around another celestial body means that celestial body completes a cycle around that other celestial body sent7: measuring sometimes requires recording / learning an amount sent8: to happen means to occur sent9: period is similar to amount of time sent10: the solar system is a kind of system sent11: small stars burn for billions of years sent12: to be made of something means to be formed of that something sent13: earth is a kind of planet sent14: planets orbit stars sent15: revolving is a kind of action sent16: a measure of time is a length of time sent17: long means great in length sent18: to cause means to make sent19: approximately means about sent20: a period in the periodic table means a row in the periodic table sent21: celestial bodies move in orbits in space around other celestial bodies sent22: amount is a property of something and includes ordered values of none / least / little / some / half / much / many / most / all sent23: the sun is a kind of star sent24: planets are found in space sent25: to a human a time period of 1 century / generation to many centuries / generations is considered very long", "question": "About how long does it take Earth to make one revolution around the Sun?", "answer": "a year", "hypothesis": "a complete revolution of the earth around the sun will take one earth year", "proof": "sent1 & sent13 & sent23 -> int1: the earth revolving around the sun is an example of a planet revolving around its star; int1 & sent2 -> hypothesis; ", "full_text_proof": " [BECAUSE] the earth revolves around the sun [AND] earth is a kind of planet [AND] the sun is a kind of star [INFER] int1: the earth revolving around the sun is an example of a planet revolving around its star [BECAUSE] int1 [AND] a complete revolution / orbit of a planet around its star takes 1 / one planetary year [INFER] int2: a complete revolution of the earth around the sun will take one earth year", "depth_of_proof": 2, "length_of_proof": 2, "meta": {"question_text": "About how long does it take Earth to make one revolution around the Sun?", "answer_text": "a year", "hypothesis_id": "int2", "triples": {"sent1": "the earth revolves around the sun", "sent2": "a complete revolution / orbit of a planet around its star takes 1 / one planetary year", "sent3": "planets in the solar system orbit the sun", "sent4": "1 month is equal to 28-31 days", "sent5": "revolving around something means orbiting that something", "sent6": "a celestial body travelling around another celestial body means that celestial body completes a cycle around that other celestial body", "sent7": "measuring sometimes requires recording / learning an amount", "sent8": "to happen means to occur", "sent9": "period is similar to amount of time", "sent10": "the solar system is a kind of system", "sent11": "small stars burn for billions of years", "sent12": "to be made of something means to be formed of that something", "sent13": "earth is a kind of planet", "sent14": "planets orbit stars", "sent15": "revolving is a kind of action", "sent16": "a measure of time is a length of time", "sent17": "long means great in length", "sent18": "to cause means to make", "sent19": "approximately means about", "sent20": "a period in the periodic table means a row in the periodic table", "sent21": "celestial bodies move in orbits in space around other celestial bodies", "sent22": "amount is a property of something and includes ordered values of none / least / little / some / half / much / many / most / all", "sent23": "the sun is a kind of star", "sent24": "planets are found in space", "sent25": "to a human a time period of 1 century / generation to many centuries / generations is considered very long"}, "distractors": ["sent16", "sent5", "sent19", "sent7", "sent6", "sent11", "sent17", "sent9", "sent14", "sent22", "sent15", "sent8", "sent3", "sent10", "sent24", "sent18", "sent21", "sent25", "sent4", "sent12", "sent20"], "distractors_relevance": [-4.514895, -6.502503, -8.087954, -13.832006, -14.110043, -14.739609, -15.114659, -15.307732, -15.349216, -15.865791, -16.77327, -16.927134, -17.040472, -17.248245, -17.678596, -18.146978, -18.208649, -18.234707, -19.007717, -19.199781, -19.799143], "intermediate_conclusions": {"int1": "the earth revolving around the sun is an example of a planet revolving around its star", "int2": "a complete revolution of the earth around the sun will take one earth year"}, "core_concepts": ["a complete revolution / orbit of a planet around its star takes 1 / one planetary year"], "step_proof": "sent1 & sent13 & sent23 -> int1: the earth revolving around the sun is an example of a planet revolving around its star; int1 & sent2 -> hypothesis; ", "lisp_proof": "((((sent1 sent13 sent23) -> int1) sent2) -> int2)", "polish_proof": "# int2 & # int1 & sent1 & sent13 sent23 sent2", "worldtree_provenance": {"sent1": {"uuid": "af26-8083-b908-7d3b", "original_text": "the sun is a kind of star"}, "sent2": {"uuid": "e473-7297-61c1-56fa", "original_text": "earth is a kind of planet"}, "sent3": {"uuid": "b107-d162-bbc9-c5d8", "original_text": "a complete revolution / orbit of a planet around its star takes 1 / one planetary year"}, "sent4": {"uuid": "5471-05b0-00bd-1669", "original_text": "the earth revolves around the sun"}}, "add_list": [], "delete_list": [{"uuid": "e682-f47d-cc9c-a67c", "fact": "a complete revolution / orbit of the earth around the sun takes 1 / one year / solar year / earth year"}, {"uuid": "43e4-e85d-d544-57a6", "fact": "earth 's revolution is a kind of cycle"}, {"uuid": "cc92-3103-fbe1-a87a", "fact": "how long something takes is a kind of measurement of time"}, {"uuid": "406d-464a-cfa5-7b67", "fact": "years are a kind of unit for measuring time"}, {"uuid": "3678-1c03-c983-ba31", "fact": "a revolution occurs when something revolves around something else"}, {"uuid": "4753-1b7f-3bca-f7bf", "fact": "years y are a metric unit used for measuring time generally used for values between 1 and 14000000000"}, {"uuid": "02f7-3d00-6d43-0289", "fact": "revolving is a kind of motion"}, {"uuid": "dbe8-e776-f804-99a0", "fact": "a star is a kind of celestial object / celestial body"}, {"uuid": "22a2-1029-702e-a29a", "fact": "a planet is a kind of celestial object / body"}, {"uuid": "b4c6-2b18-f3a5-5096", "fact": "a planet 's distance from the star causes the length of a planetary year"}, {"uuid": "e901-c400-086c-8302", "fact": "a motion is a kind of event / action"}, {"uuid": "50fe-e0b2-8acf-6f7c", "fact": "a planet is a kind of celestial object / celestial body"}, {"uuid": "4adf-935f-2a7e-de97", "fact": "1 year is equal to 365 days"}, {"uuid": "9a65-934e-c26e-f453", "fact": "the sun is a kind of yellow dwarf"}, {"uuid": "6237-63a3-810f-6aa1", "fact": "1 year is equal to 12 months"}, {"uuid": "3b7f-815d-511b-c7bb", "fact": "a process is a kind of event"}]}},
    {"id": "Mercury_7011270", "context": "sent1: a measure of time is a length of time sent2: measuring sometimes requires recording / learning an amount sent3: months ( m ) are a metric unit used for measuring time generally used for values between 1 and 24 sent4: moons orbit planets sent5: to cause means to result in sent6: month is a kind of period of time sent7: a moon phase is a kind of natural event sent8: quickly means in a short period of time sent9: period is similar to amount of time sent10: 1 day is equal to 24 hours sent11: approximately means about sent12: a moon is located in space sent13: hours are a kind of unit for measuring time sent14: months are a kind of unit for measuring time sent15: to happen means to occur sent16: 1 month is equal to 28-31 days sent17: amount is a property of something and includes ordered values of none / least / little / some / half / much / many / most / all sent18: a celestial body travelling around another celestial body means that celestial body completes a cycle around that other celestial body sent19: take place means happen sent20: the moon is earth 's moon sent21: hours ( hr ) are a metric unit used for measuring time generally used for values between 025 and 72 sent22: a moon is a kind of satellite sent23: the moon rising occurs once per day sent24: a complete revolution / orbit of the moon around the earth takes 1 / one month sent25: each of the moon 's phases occurs once per month", "question": "About how long does it take for the Moon to complete one revolution around Earth?", "answer": "30 days", "hypothesis": "a complete revolution of the moon around the earth takes 28 to 31 days", "proof": "sent16 & sent24 -> hypothesis; ", "full_text_proof": " [BECAUSE] 1 month is equal to 28-31 days [AND] a complete revolution / orbit of the moon around the earth takes 1 / one month [INFER] int1: a complete revolution of the moon around the earth takes 28 to 31 days", "depth_of_proof": 1, "length_of_proof": 1, "meta": {"question_text": "About how long does it take for the Moon to complete one revolution around Earth?", "answer_text": "30 days", "hypothesis_id": "int1", "triples": {"sent1": "a measure of time is a length of time", "sent2": "measuring sometimes requires recording / learning an amount", "sent3": "months ( m ) are a metric unit used for measuring time generally used for values between 1 and 24", "sent4": "moons orbit planets", "sent5": "to cause means to result in", "sent6": "month is a kind of period of time", "sent7": "a moon phase is a kind of natural event", "sent8": "quickly means in a short period of time", "sent9": "period is similar to amount of time", "sent10": "1 day is equal to 24 hours", "sent11": "approximately means about", "sent12": "a moon is located in space", "sent13": "hours are a kind of unit for measuring time", "sent14": "months are a kind of unit for measuring time", "sent15": "to happen means to occur", "sent16": "1 month is equal to 28-31 days", "sent17": "amount is a property of something and includes ordered values of none / least / little / some / half / much / many / most / all", "sent18": "a celestial body travelling around another celestial body means that celestial body completes a cycle around that other celestial body", "sent19": "take place means happen", "sent20": "the moon is earth 's moon", "sent21": "hours ( hr ) are a metric unit used for measuring time generally used for values between 025 and 72", "sent22": "a moon is a kind of satellite", "sent23": "the moon rising occurs once per day", "sent24": "a complete revolution / orbit of the moon around the earth takes 1 / one month", "sent25": "each of the moon 's phases occurs once per month"}, "distractors": ["sent10", "sent3", "sent20", "sent25", "sent1", "sent4", "sent11", "sent18", "sent21", "sent23", "sent17", "sent6", "sent9", "sent2", "sent19", "sent13", "sent14", "sent12", "sent15", "sent22", "sent8", "sent5", "sent7"], "distractors_relevance": [0.52295446, -3.8120387, -5.8970294, -6.2954936, -6.5899005, -7.2750177, -8.192621, -9.570562, -9.866757, -10.670511, -11.031731, -11.50796, -11.808062, -12.23937, -14.608202, -14.738592, -15.057665, -16.418053, -16.597755, -17.158653, -18.42954, -18.854452, -19.327808], "intermediate_conclusions": {"int1": "a complete revolution of the moon around the earth takes 28 to 31 days"}, "core_concepts": ["a complete revolution / orbit of the moon around the earth takes 1 / one month"], "step_proof": "sent16 & sent24 -> hypothesis; ", "lisp_proof": "((sent16 sent24) -> int1)", "polish_proof": "# int1 & sent16 sent24", "worldtree_provenance": {"sent1": {"uuid": "74a1-0a11-f9ce-9501", "original_text": "1 month is equal to 28-31 days"}, "sent2": {"uuid": "9baa-2f01-60c7-64fa", "original_text": "a complete revolution / orbit of the moon around the earth takes 1 / one month"}}, "add_list": [], "delete_list": [{"uuid": "b9b5-0df2-9cca-ef36", "fact": "the moon orbiting the earth occurs once per month"}, {"uuid": "a6a9-3e1b-7e02-ce06", "fact": "the moon orbits the earth"}, {"uuid": "cc92-3103-fbe1-a87a", "fact": "how long something takes is a kind of measurement of time"}, {"uuid": "ec3f-17e4-7f87-3757", "fact": "days are a kind of unit for measuring time"}, {"uuid": "e473-7297-61c1-56fa", "fact": "earth is a kind of planet"}, {"uuid": "3678-1c03-c983-ba31", "fact": "a revolution occurs when something revolves around something else"}, {"uuid": "a459-e38e-38fd-c536", "fact": "days d are a metric unit used for measuring time generally used for values between 1 and 365"}, {"uuid": "343e-7241-0aa2-1221", "fact": "the moon is a kind of moon"}, {"uuid": "02f7-3d00-6d43-0289", "fact": "revolving is a kind of motion"}, {"uuid": "6195-e804-0ead-efb6", "fact": "the moon completes a lunar cycle over a period of 29 days"}, {"uuid": "22a2-1029-702e-a29a", "fact": "a planet is a kind of celestial object / body"}, {"uuid": "d3ac-d13c-97bb-6a5a", "fact": "an event is a kind of action"}, {"uuid": "e2ec-1655-c1fd-cb58", "fact": "a moon is a kind of celestial object / body"}, {"uuid": "5491-9457-39e4-2a7a", "fact": "a moon is a kind of celestial object / celestial body"}, {"uuid": "bc9e-70cd-ccf9-d3f6", "fact": "a moon phase occurs 28 days after the last time it occurred"}, {"uuid": "e901-c400-086c-8302", "fact": "a motion is a kind of event / action"}, {"uuid": "e70b-e515-02a3-8958", "fact": "the moon revolving around / orbiting the earth causes the phases of the moon"}, {"uuid": "50fe-e0b2-8acf-6f7c", "fact": "a planet is a kind of celestial object / celestial body"}, {"uuid": "3b7f-815d-511b-c7bb", "fact": "a process is a kind of event"}]}},
    {"id": "MCAS_2004_9_16", "context": "sent1: the gravitational pull of the moon on earth 's oceans causes the tides sent2: the moon is a kind of moon sent3: ocean tides are a kind of phenomenon sent4: a coast is where land meets the edge of a body of water sent5: gravity is a kind of force sent6: if something causes something else then that something else depends on that something sent7: the surface of the moon contains mountains sent8: the cause of something affects that something sent9: the sun is the strongest source of gravity in the solar system sent10: the moon is the celestial object that is closer to the earth than the sun sent11: determining often requires measuring / observing sent12: gravity causes orbits sent13: as the gravitational pull of the moon decreases , the height of ocean tides will decrease sent14: the gravitational pull of the sun on earth 's oceans causes the tides sent15: the tide is when ocean levels periodically rise / fall sent16: an ocean is a kind of body of water sent17: the moon is earth 's moon sent18: when a hemisphere is tilted away from the sun , that hemisphere receives less direct sunlight sent19: the earth has more mass than the moon sent20: a tide is a kind of natural event sent21: a pull is a kind of force sent22: moons orbit planets sent23: as distance from an object decreases , the pull of gravity on that object increases sent24: a moon is located in space sent25: tidal means related to tides", "question": "Tides, such as those along the coast of Massachusetts, are caused by gravitational attractions acting on Earth. Why is the gravitational attraction of the Moon a greater factor in determining tides than the gravitational attraction of the much larger Sun?", "answer": "Earth is much closer to the Moon than to the Sun.", "hypothesis": "the gravitational pull of the moon on earth affects the tides more than the gravitational pull of the sun", "proof": "sent10 & sent23 -> int1: the gravity pull from the moon on earth is greater than the sun on earth; int1 & sent1 & sent14 & sent8 -> hypothesis; ", "full_text_proof": " [BECAUSE] the moon is the celestial object that is closer to the earth than the sun [AND] as distance from an object decreases , the pull of gravity on that object increases [INFER] int1: the gravity pull from the moon on earth is greater than the sun on earth [BECAUSE] int1 [AND] the gravitational pull of the moon on earth 's oceans causes the tides [AND] the gravitational pull of the sun on earth 's oceans causes the tides [AND] the cause of something affects that something [INFER] int2: the gravitational pull of the moon on earth affects the tides more than the gravitational pull of the sun", "depth_of_proof": 2, "length_of_proof": 2, "meta": {"question_text": "Tides, such as those along the coast of Massachusetts, are caused by gravitational attractions acting on Earth. Why is the gravitational attraction of the Moon a greater factor in determining tides than the gravitational attraction of the much larger Sun?", "answer_text": "Earth is much closer to the Moon than to the Sun.", "hypothesis_id": "int2", "triples": {"sent1": "the gravitational pull of the moon on earth 's oceans causes the tides", "sent2": "the moon is a kind of moon", "sent3": "ocean tides are a kind of phenomenon", "sent4": "a coast is where land meets the edge of a body of water", "sent5": "gravity is a kind of force", "sent6": "if something causes something else then that something else depends on that something", "sent7": "the surface of the moon contains mountains", "sent8": "the cause of something affects that something", "sent9": "the sun is the strongest source of gravity in the solar system", "sent10": "the moon is the celestial object that is closer to the earth than the sun", "sent11": "determining often requires measuring / observing", "sent12": "gravity causes orbits", "sent13": "as the gravitational pull of the moon decreases , the height of ocean tides will decrease", "sent14": "the gravitational pull of the sun on earth 's oceans causes the tides", "sent15": "the tide is when ocean levels periodically rise / fall", "sent16": "an ocean is a kind of body of water", "sent17": "the moon is earth 's moon", "sent18": "when a hemisphere is tilted away from the sun , that hemisphere receives less direct sunlight", "sent19": "the earth has more mass than the moon", "sent20": "a tide is a kind of natural event", "sent21": "a pull is a kind of force", "sent22": "moons orbit planets", "sent23": "as distance from an object decreases , the pull of gravity on that object increases", "sent24": "a moon is located in space", "sent25": "tidal means related to tides"}, "distractors": ["sent13", "sent9", "sent5", "sent15", "sent19", "sent2", "sent3", "sent17", "sent16", "sent18", "sent22", "sent4", "sent7", "sent12", "sent25", "sent6", "sent21", "sent24", "sent11", "sent20"], "distractors_relevance": [3.7911959, 3.7349107, -6.118892, -6.6782713, -9.07393, -10.062855, -10.489155, -11.266609, -11.6533, -12.639583, -13.048809, -13.593544, -14.490616, -14.754548, -14.869966, -16.927872, -16.981165, -17.48952, -17.723671, -18.15414], "intermediate_conclusions": {"int1": "the gravity pull from the moon on earth is greater than the sun on earth", "int2": "the gravitational pull of the moon on earth affects the tides more than the gravitational pull of the sun"}, "core_concepts": ["as distance from an object decreases , the pull of gravity on that object increases"], "step_proof": "sent10 & sent23 -> int1: the gravity pull from the moon on earth is greater than the sun on earth; int1 & sent1 & sent14 & sent8 -> hypothesis; ", "lisp_proof": "((((sent10 sent23) -> int1) sent1 sent14 sent8) -> int2)", "polish_proof": "# int2 & # int1 & sent10 sent23 & sent1 & sent14 sent8", "worldtree_provenance": {"sent1": {"uuid": "ddca-37d6-9e7b-d216", "original_text": "the gravitational pull of the moon on earth 's oceans causes the tides"}, "sent2": {"uuid": "9d4d-3bfb-e0e2-d068", "original_text": "as distance from an object decreases , the pull of gravity on that object increases"}, "sent3": {"uuid": "a988-da0d-6d1a-f0b4", "original_text": "the moon is the celestial object that is closer to the earth than the sun"}, "sent4": {"uuid": "b75d-4ff4-3225-6e84", "original_text": "the gravitational pull of the sun on earth 's oceans causes the tides"}, "sent5": {"uuid": "", "original_text": "the cause of something affects that something"}}, "add_list": [{"sid": "sent5", "fact": "the cause of something affects that something"}], "delete_list": [{"uuid": "ae9e-abc3-9cb3-216c", "fact": "the moon is the celestial object that is closest to the earth"}, {"uuid": "04ee-408f-6c7a-54fc", "fact": "closer means lower / less / a decrease in distance"}, {"uuid": "cf37-a1ef-e60b-f8e7", "fact": "close means low in distance"}, {"uuid": "be98-6590-1dd0-8eb6", "fact": "as distance from an object increases , the pull of gravity on that object decrease"}, {"uuid": "dfb6-4ce2-e5ae-b00b", "fact": "as the distance from an object increases , the force of gravity on that object will decrease"}, {"uuid": "5095-dfd3-1847-a4a0", "fact": "as the gravitational pull of the moon on the earth increases , the size of the tides on earth increase"}, {"uuid": "a6a9-3e1b-7e02-ce06", "fact": "the moon orbits the earth"}, {"uuid": "91b9-6388-d5b8-58b6", "fact": "distance is a property of space and includes ordered values of close / far"}, {"uuid": "e78f-4643-92f4-383f", "fact": "as the distance from a source of something increases , that something will decrease"}, {"uuid": "e473-7297-61c1-56fa", "fact": "earth is a kind of planet"}, {"uuid": "94b7-fbe6-74cf-eba2", "fact": "far means great in distance"}, {"uuid": "2fb5-7bf0-d5d7-3224", "fact": "near / close is the opposite of far / away"}, {"uuid": "769f-6117-1272-9b62", "fact": "far is the opposite of close"}, {"uuid": "bfdf-b468-ee22-1b60", "fact": "an increase is the opposite of a decrease"}, {"uuid": "e5c0-79e6-37a7-4b77", "fact": "larger / bigger is the opposite of smaller"}, {"uuid": "af26-8083-b908-7d3b", "fact": "the sun is a kind of star"}, {"uuid": "b94c-5bde-8d46-29de", "fact": "a factor impacts something"}, {"uuid": "4e12-62f2-0830-d602", "fact": "the sun is the star that is closest to earth"}, {"uuid": "842e-1407-d27c-3e94", "fact": "greatest means largest / highest / most amount of something"}, {"uuid": "a352-bde5-b854-f460", "fact": "earth is the planet that is third closest to the sun"}, {"uuid": "8b56-35cc-d534-8cad", "fact": "larger means greater / higher / more / increase in size"}, {"uuid": "e2ec-1655-c1fd-cb58", "fact": "a moon is a kind of celestial object / body"}, {"uuid": "2f53-db43-c6e9-95bc", "fact": "greater means higher / more in value"}, {"uuid": "22a2-1029-702e-a29a", "fact": "a planet is a kind of celestial object / body"}, {"uuid": "dbe8-e776-f804-99a0", "fact": "a star is a kind of celestial object / celestial body"}, {"uuid": "6e2c-b252-430e-971b", "fact": "attract means move closer"}]}},
    {"id": "Mercury_7176085", "context": "sent1: near means close sent2: proximity means distance sent3: attracting something to a location causes that something to be near that location sent4: nearby is similar to near sent5: the moon orbiting the earth occurs once per month sent6: distant means far away sent7: the moon is earth 's moon sent8: if something has a positive impact on something else then that something is important to that something else sent9: influence means effect sent10: the moon reflects sunlight towards the earth sent11: the moon is the celestial object that is closer to the earth than the sun sent12: the gravitational pull of the moon on earth 's oceans causes the tides sent13: a factor impacts something sent14: the gravitational pull of the sun on earth 's oceans causes the tides sent15: as distance from an object decreases , the pull of gravity on that object increases sent16: moons orbit planets sent17: when a hemisphere is tilted away from the sun , that hemisphere receives less direct sunlight sent18: influence means impact sent19: winter is when a hemisphere is tilted away from the sun sent20: if two or more things are in a relationship then those things impact each other sent21: distant means great in distance sent22: as the gravitational pull of the moon on the earth increases , the size of the tides on earth increase sent23: ocean tides are a kind of phenomenon sent24: the moon revolving around / orbiting the earth causes the phases of the moon sent25: as the gravitational pull of the moon decreases , the height of ocean tides will decrease", "question": "The influence of the Moon on the tides on Earth is greater than that of the Sun. Which best explains this?", "answer": "The Moon is closer to Earth than the Sun.", "hypothesis": "the gravitational pull of the moon on earth affects the tides more than the gravitational pull of the sun", "proof": "sent11 & sent15 -> int1: the gravity pull from the moon on earth is greater than the sun on earth; int1 & sent12 & sent14 -> hypothesis; ", "full_text_proof": " [BECAUSE] the moon is the celestial object that is closer to the earth than the sun [AND] as distance from an object decreases , the pull of gravity on that object increases [INFER] int1: the gravity pull from the moon on earth is greater than the sun on earth [BECAUSE] int1 [AND] the gravitational pull of the moon on earth 's oceans causes the tides [AND] the gravitational pull of the sun on earth 's oceans causes the tides [INFER] int2: the gravitational pull of the moon on earth affects the tides more than the gravitational pull of the sun", "depth_of_proof": 2, "length_of_proof": 2, "meta": {"question_text": "The influence of the Moon on the tides on Earth is greater than that of the Sun. Which best explains this?", "answer_text": "The Moon is closer to Earth than the Sun.", "hypothesis_id": "int2", "triples": {"sent1": "near means close", "sent2": "proximity means distance", "sent3": "attracting something to a location causes that something to be near that location", "sent4": "nearby is similar to near", "sent5": "the moon orbiting the earth occurs once per month", "sent6": "distant means far away", "sent7": "the moon is earth 's moon", "sent8": "if something has a positive impact on something else then that something is important to that something else", "sent9": "influence means effect", "sent10": "the moon reflects sunlight towards the earth", "sent11": "the moon is the celestial object that is closer to the earth than the sun", "sent12": "the gravitational pull of the moon on earth 's oceans causes the tides", "sent13": "a factor impacts something", "sent14": "the gravitational pull of the sun on earth 's oceans causes the tides", "sent15": "as distance from an object decreases , the pull of gravity on that object increases", "sent16": "moons orbit planets", "sent17": "when a hemisphere is tilted away from the sun , that hemisphere receives less direct sunlight", "sent18": "influence means impact", "sent19": "winter is when a hemisphere is tilted away from the sun", "sent20": "if two or more things are in a relationship then those things impact each other", "sent21": "distant means great in distance", "sent22": "as the gravitational pull of the moon on the earth increases , the size of the tides on earth increase", "sent23": "ocean tides are a kind of phenomenon", "sent24": "the moon revolving around / orbiting the earth causes the phases of the moon", "sent25": "as the gravitational pull of the moon decreases , the height of ocean tides will decrease"}, "distractors": ["sent25", "sent22", "sent2", "sent10", "sent7", "sent17", "sent1", "sent20", "sent16", "sent6", "sent21", "sent18", "sent24", "sent9", "sent19", "sent4", "sent13", "sent23", "sent5", "sent8", "sent3"], "distractors_relevance": [9.08874, 7.6241174, -2.388395, -2.8731215, -3.315129, -4.36418, -7.6047454, -8.474146, -9.629267, -11.848907, -12.423294, -13.474245, -13.568382, -13.71591, -14.760046, -14.939032, -15.029242, -15.659904, -16.624533, -16.678364, -16.93625], "intermediate_conclusions": {"int1": "the gravity pull from the moon on earth is greater than the sun on earth", "int2": "the gravitational pull of the moon on earth affects the tides more than the gravitational pull of the sun"}, "core_concepts": ["as distance from an object decreases , the pull of gravity on that object increases"], "step_proof": "sent11 & sent15 -> int1: the gravity pull from the moon on earth is greater than the sun on earth; int1 & sent12 & sent14 -> hypothesis; ", "lisp_proof": "((((sent11 sent15) -> int1) sent12 sent14) -> int2)", "polish_proof": "# int2 & # int1 & sent11 sent15 & sent12 sent14", "worldtree_provenance": {"sent1": {"uuid": "ddca-37d6-9e7b-d216", "original_text": "the gravitational pull of the moon on earth 's oceans causes the tides"}, "sent2": {"uuid": "b75d-4ff4-3225-6e84", "original_text": "the gravitational pull of the sun on earth 's oceans causes the tides"}, "sent3": {"uuid": "a988-da0d-6d1a-f0b4", "original_text": "the moon is the celestial object that is closer to the earth than the sun"}, "sent4": {"uuid": "9d4d-3bfb-e0e2-d068", "original_text": "as distance from an object decreases , the pull of gravity on that object increases"}}, "add_list": [], "delete_list": [{"uuid": "ae9e-abc3-9cb3-216c", "fact": "the moon is the celestial object that is closest to the earth"}, {"uuid": "be98-6590-1dd0-8eb6", "fact": "as distance from an object increases , the pull of gravity on that object decrease"}, {"uuid": "91b9-6388-d5b8-58b6", "fact": "distance is a property of space and includes ordered values of close / far"}, {"uuid": "2f53-db43-c6e9-95bc", "fact": "greater means higher / more in value"}, {"uuid": "04ee-408f-6c7a-54fc", "fact": "closer means lower / less / a decrease in distance"}, {"uuid": "e473-7297-61c1-56fa", "fact": "earth is a kind of planet"}, {"uuid": "af26-8083-b908-7d3b", "fact": "the sun is a kind of star"}, {"uuid": "dfb6-4ce2-e5ae-b00b", "fact": "as the distance from an object increases , the force of gravity on that object will decrease"}, {"uuid": "abe7-8ef7-d11e-25ca", "fact": "the tide is when ocean levels periodically rise / fall"}, {"uuid": "a6a9-3e1b-7e02-ce06", "fact": "the moon orbits the earth"}, {"uuid": "343e-7241-0aa2-1221", "fact": "the moon is a kind of moon"}, {"uuid": "e78f-4643-92f4-383f", "fact": "as the distance from a source of something increases , that something will decrease"}, {"uuid": "2fb5-7bf0-d5d7-3224", "fact": "near / close is the opposite of far / away"}, {"uuid": "769f-6117-1272-9b62", "fact": "far is the opposite of close"}, {"uuid": "cf37-a1ef-e60b-f8e7", "fact": "close means low in distance"}, {"uuid": "bfdf-b468-ee22-1b60", "fact": "an increase is the opposite of a decrease"}, {"uuid": "94b7-fbe6-74cf-eba2", "fact": "far means great in distance"}, {"uuid": "782a-53e7-c1c7-aae0", "fact": "an increase is a kind of change"}, {"uuid": "ecca-9a1d-3074-cd00", "fact": "higher means greater / above in value / amount / number"}, {"uuid": "4e12-62f2-0830-d602", "fact": "the sun is the star that is closest to earth"}, {"uuid": "842e-1407-d27c-3e94", "fact": "greatest means largest / highest / most amount of something"}, {"uuid": "a352-bde5-b854-f460", "fact": "earth is the planet that is third closest to the sun"}, {"uuid": "e2ec-1655-c1fd-cb58", "fact": "a moon is a kind of celestial object / body"}, {"uuid": "22a2-1029-702e-a29a", "fact": "a planet is a kind of celestial object / body"}, {"uuid": "dbe8-e776-f804-99a0", "fact": "a star is a kind of celestial object / celestial body"}]}},
]

TEST_PARAPHRASES = [
    {
        "sample_idx": "Mercury_7086205",
        "response": {
            "response": "From the options provided, select a statement that accurately describes a property of gold.|Which of the following traits is specific to the element gold?|Identify the correct quality of the metal gold from the choices below.|Gold possesses several key features; which of these is one of them?|Out of the following, which is a true statement regarding the characteristics of the metal gold?",
            "completion_tokens": 999,
            "reasoning": "**Defining the Core Question**\n\nI'm focused on breaking down the original claim. It's a multiple-choice query, and I'm identifying the core elements. The phrase \"Which of these\" points toward options presented in a list format, which I need to preserve.\n\n\n**Formulating Alternative Phrases**\n\nI've generated a few more potential phrasing options. I'm leaning toward concise and direct reformulations. Some approaches use more technical terms, others use more casual language. Currently refining the structure to maximize the differences between the final five paraphrases.\n\n\n**Constructing the Final Paraphrases**\n\nI'm now focusing on combining the best options. I like Paraphrase 1 and Paraphrase 5. I am also editing paraphrase 3 to refine its structure to better match the overall styles. I'm carefully weighing the balance between scientific accuracy and accessible language to ensure all the options are clear, while also being distinct in structure. The goal is to have varied vocabulary and sentence construction across all five versions.\n\n\n**Synthesizing Final Output**\n\nI've reviewed and refined the five paraphrases. They are each now complete and distinct in their structure and phrasing. I am satisfied that all five options successfully rephrase the original query about gold while maintaining the core requirement of selecting a characteristic. The final formatting using the '|' separator is now in process, ready for the final output.\n\n\n"
        }
    },
    {
        "sample_idx": "Mercury_7164658",
        "response": {
            "response": "What is the principal force compelling Earth and the other planets to maintain their counterclockwise orbits around the Sun? | The planets in our solar system, including Earth, all circle the Sun in a counterclockwise trajectory; which force is the primary driver of this orbital motion? | Identify the main force responsible for causing Earth and its planetary companions to revolve in a counterclockwise path around the Sun. | All planets, our own included, follow a counterclockwise path as they journey around the Sun. What is the dominant force behind this cosmic revolution? | Considering that Earth and all other planets orbit the Sun in a counterclockwise fashion, what is the fundamental force that governs this movement?",
            "completion_tokens": 953,
            "reasoning": "**Comprehending Planetary Motion**\n\nI'm tackling the paraphrasing task. My current focus is identifying the core semantic components of the provided claim. I am breaking down the sentence into manageable pieces to ensure the paraphrases maintain the original meaning, focusing on the sun, planets, and counterclockwise rotation.\n\n\n**Exploring Revolutions' Dynamics**\n\nI'm aiming to create varied paraphrases. I've identified semantic components: subjects, actions, and central objects. Now, I'm brainstorming phrasing options. I've crafted two initial versions: one formal and scientific, and another concise and direct. Currently, I'm outlining a story-driven approach to enrich the paraphrasing.\n\n\n**Constructing Varied Phrasing**\n\nI'm now creating those five paraphrases. I've mapped out the subjects, actions, central objects, directions, and question. I’ve drafted a formal scientific paraphrase, and a concise one, and have also started drafting two more paraphrases using different styles: an inquisitive, storytelling style and a passive structure. I'm also including a simplified educational style. The goal is maximum divergence from the original sentence structure.\n\n\n**Generating Final Output**\n\nI've confirmed the five paraphrases' suitability. They meet all criteria and I'm confident in their semantic integrity. I'm now ready to format the responses, ensuring they're distinct. My next step will be to follow the specified format exactly.\n\n\n"
        }
    },
    {
        "sample_idx": "Mercury_SC_401178",
        "response": {
            "response": "Identify one of the stages involved in the conversion of light energy into chemical energy by plants. | Among the options provided, which event is part of the photosynthetic pathway? | What action is considered a component of how plants create their own food? | The process of photosynthesis includes which of the following key events? | Select a phase that is integral to the overall photosynthetic mechanism.",
            "completion_tokens": 1001,
            "reasoning": "**Analyzing the Core Claim**\n\nI'm breaking down the original question's components: \"Which,\" \"is,\" \"a step,\" \"in the process of,\" and \"photosynthesis.\" My goal is to understand how I can rephrase this while maintaining the core meaning. I'm identifying key phrases and thinking about synonyms and alternative structures to get started.\n\n\n**Defining Key Terms**\n\nI'm focusing on defining the key terms and concepts. I'm now looking into the specific phases of photosynthesis to ensure accuracy in the rephrasing. My goal is to fully understand each element, not just to swap words, but to fully transform the sentence, keeping it in line with the original question's meaning. This will help me to generate accurate alternatives.\n\n\n**Formulating Diverse Options**\n\nI'm now in the drafting phase, where I'm creating variations. The first draft, \"Identify an action that occurs during the photosynthetic cycle,\" is done. Following that, I have drafted a second option. The next step is to draft Paraphrase 3. I'm deliberately varying structure, vocabulary, and even the question type to maximize distinctiveness. I am considering a fill-in-the-blank type and declarative options as the next steps.\n\n\n**Finalizing the Rephrasing**\n\nI've reviewed the generated paraphrases and confirmed their suitability. I'm satisfied with the variety in structure, language, and tone. My work here is done, and the five distinct versions of the question are ready.\n\n\n**Evaluating the Alternatives**\n\nI've now reviewed and edited the proposed variations. I am happy with all 5 options: \"Identify an action that occurs during the photosynthetic cycle.\" | \"Select a component phase of the overall photosynthetic mechanism.\" | \"What is one of the stages involved when a plant converts light into chemical energy?\" | \"One of the following describes a key event within the process of photosynthesis.\" | \"Which of these is a stage in a plant's food-making process?\" They all address the prompt question from different angles. I am ready to pass these five options on.\n\n\n"
        }
    },
    {
        "sample_idx": "NAEP_2000_4_S21+2",
        "response": {
            "response": "To determine the type of a newly discovered rock, as Beryl is attempting to do, which of its properties would be the most informative? | What is the single most important characteristic to observe when identifying a rock? | If Beryl wants to classify a stone she found, which feature will give her the best clue about what kind it is? | Of all the rock's attributes, which one is the key to successfully categorizing the specimen Beryl has found? | Beryl is trying to figure out what kind of rock she has; which piece of information about it would be the most helpful for her classification?",
            "completion_tokens": 1098,
            "reasoning": "**Defining Identification Parameters**\n\nI've been refining the key elements for rock identification. My focus is on crafting five distinct paraphrases of the initial claim, ensuring each retains its core meaning while highlighting different aspects of the identification process. Currently, I'm assessing the impact of varied terminology on the overall comprehension and specificity.\n\n\n**Reframing the Core Question**\n\nI'm finalizing the phrasing, currently working on paraphrase 2, aiming for brevity and directness, cutting out the extraneous narrative elements. I've decided to prioritize clarity. I'm also considering the strategic use of different sentence structures, ensuring that each paraphrase approaches the core question from a distinct perspective, while maintaining accuracy.\n\n\n**Constructing the Initial Paraphrases**\n\nI've completed the first draft of all five paraphrases, focusing on the key elements identified earlier. I've ensured each one maintains the original meaning while varying in style, structure, and length as requested. Now, I'm carefully reviewing each paraphrase, evaluating them against the criteria to confirm they are distinct, accurate, and effectively convey the central question, with adjustments needed to avoid redundancy.\n\n\n**Crafting Final Versions**\n\nI've reviewed the paraphrases for divergence and accuracy, refining each based on the feedback. I've adjusted the vocabulary and phrasing to ensure the five versions are distinct in tone, structure, and complexity. I'm now preparing to present them as requested, separated by the pipe symbol.\n\n\n**Assembling the Final Product**\n\nI've finalized the five paraphrases, ensuring each aligns with the requirements for meaning, distinctiveness, and presentation. I have reviewed my final drafts against my criteria and am now prepared for the formatting and presentation of the results.\n\n\n"
        }
    },
    {
        "sample_idx": "Mercury_SC_415696",
        "response": {
            "response": "Could you provide an example of a physical interaction that results in the generation of thermal energy? | Describe a real-world scenario where the application of a force causes something to get hotter. | How can a force be used to create warmth? | Illustrate the principle of a force causing an increase in temperature with a specific case. | Name a process where mechanical action is converted into heat.",
            "completion_tokens": 1079,
            "reasoning": "**Rewording the Inquiry**\n\nI'm currently working on rephrasing the user's question about forces and heat. I've identified the core meaning: finding a scenario where a force leads to heat generation. My focus is on generating diverse, yet equivalent, paraphrases. I aim for at least five variations to capture this concept.\n\n\n**Revising the Draft**\n\nI've been developing the first paraphrase, aiming for a technical slant. I've decided to replace \"mechanical action\" with \"applied force\" to better align with the user's prompt and increase clarity. The sentence structure is also undergoing modification to enhance its scientific tone. I'm now working to finish the first complete paraphrase.\n\n\n**Developing Variation Five**\n\nI'm finalizing the fifth paraphrase, concentrating on an indirect question style. I aim for a blend of technical and practical. I'm considering options that emphasize the consequence of the force. Currently refining the sentence structure to make it concise and clear.\n\n\n**Evaluating the Output**\n\nI've assessed the five paraphrases based on the criteria. I'm satisfied with the variety in vocabulary, structure, style, and length. Now, I need to ensure they're maximally different, focusing on subtle refinements. I'm making the final checks.\n\n\n**Completing the Set**\n\nI've reviewed the drafts and am happy with the variety. I've confirmed that each paraphrase meets the requirements: preserving meaning and maximizing differences. I'm now formatting them and will add the requested separator.\n\n\n"
        }
    },
]

class EntailmentBankDatasetMock():
    def __init__(self):
        self.data = []
        raw_data = TEST_SAMPLES
        paraphrases = TEST_PARAPHRASES

        for entry, paraphrases in zip(raw_data, paraphrases):
            if paraphrases is not None:
                paraphrases = paraphrases["response"]["response"].split("|")
                paraphrases = [phrase.strip() for phrase in paraphrases]
            else:
                paraphrases = None

            # All scores initially are set to True since the proofs are presumed correct.
            example = {
                "id": entry["id"],
                "proof": entry["meta"]["step_proof"] if "meta" in entry and "step_proof" in entry["meta"] else entry["step_proof"],
                "question": entry["meta"]["question_text"],
                "question_paraphrases": paraphrases,
                "answer": entry["meta"]["answer_text"],
                "context": entry["meta"]["triples"],
                "hypothesis": entry["hypothesis"],
                "intermediate_conclusions": entry["meta"]["intermediate_conclusions"],
                "hypothesis_id": entry["meta"]["hypothesis_id"],
                "distractors": entry["meta"]["distractors"],
                "score": True,
            }
            assert example["question_paraphrases"] is not None, "Question paraphrases are required for entailment intervention"
            assert example["distractors"] is not None, "Distractors are required for entailment intervention"
            assert example["proof"] is not None, "Proof is required for entailment intervention"
            assert example["question"] is not None, "Question is required for entailment intervention"
            assert example["context"] is not None, "Context is required for entailment intervent"

            self.data.append(example)

    def __len__(self):
        return len(self.data)

    def __getitem__(self, idx):
        return self.data[idx]
