# Submission #1070 (ICLR 2025)

## Enhancing Certified Robustness via Block Reflector Orthogonal Layers

## Description

To ensure the reproducibility of our experiments, we provide a detailed implementation of the proposed BRO method. This is a version for reviewers to check the implementation and reproducibility.

## Structure

We use two different architectures, each organized into its respective folder. Below is a summary of some important files:

- bronet
  - train.py: the driver code to train BRONet.
  - bronet/models/*: the component to construct BRONet.
- lipconvnet
  - main.py: the driver code to train LipConvNet.
  - lipconvnet/models/*: the component to construct LipConvNet. We also provide the implementation of SOC and LOT.
  - bro_conv.py: this file implement Algorithm 1 in the paper.

```
.
├── bronet 
│   ├── configs
│   ├── models
│   │   ├── backbone.py
│   │   ├── cholesky_grad.py
│   │   ├── dense.py
│   │   ├── head.py
│   │   ├── layers
│   │   │   ├── activation.py
│   │   │   ├── conv.py
│   │   │   ├── linear.py
│   │   ├── margin_layer.py
│   │   ├── model.py
│   │   ├── neck.py
│   │   └── stem.py
│   ├── tools
│   └── train.py
│  
├── lipconvnet
│   ├── main.py
│   ├── models
│   │   ├── layers
│   │   │   ├── bro_conv.py
│   │   │   └── ...
│   │   ├── lip_block.py
│   │   ├── lip_convnets.py
│   │   └── lip_resnets.py
│   ├── trainer
│   │   └── trainer.py
│   └── utils
└── README.md
```

## Requirements

The code has been implemented and tested with `Python 3.11.2`
To install requirements:

```setup
pip install -r requirements.txt
```

## Data

Before start training, the code will automatically create `cifar_data/` directory and downloaded the required data to `cifar10/`, `cifar100/` ([cifar10 and cifar100](https://www.cs.toronto.edu/~kriz/cifar.html)), and `tiny-imagenet-200` directory ([tiny-imagenet-200](https://gist.github.com/moskomule/2e6a9a463f50447beca4e64ab4699ac4)).

## Credits

[LiResNet](https://github.com/hukkai/liresnet)

[SOC](https://github.com/singlasahil14/SOC)

[LOT](https://github.com/AI-secure/Layerwise-Orthogonal-Training)
