<!--
https://github.com/paperswithcode/releasing-research-code/blob/master/templates/README.md
-->

# Mechanism design with multi-armed bandit

This repository is the official implementation of "Mechanism design with multi-armed bandit". 

## Requirements

We set up the environment with poetry.  To install requirements:

```setup
poetry install
```

## Run all

Run this command to run all experiments and plot all figures in the paper.
```run
./run.sh
```

## Run each

Alternatively, you can run each experiment separately.

### Best Mean Estimation with moderate number of arms
```
for epsilon in 0.2 0.1 0.05
do
    for delta in 0.2 0.1 0.05
    do
        echo poetry run python exp_bme_vs_bai.py --epsilon $epsilon --delta $delta --run --plot
        poetry run python exp_bme_vs_bai.py --epsilon $epsilon --delta $delta --run --plot
    done
done
```
will produce 
![fig1](images/fig1.png)

### Effectiveness of Best Mean Estimation in mechanism design
```
for players in 4 6 8
do
    for types in 4 6 8
    do
        echo poetry run python exp_bandit_sample.py --players $players --types $types --run --plot
        poetry run python exp_bandit_sample.py --players $players --types $types --run --plot
    done
done
```
will produce 
![fig2](images/fig2.png)

```
echo poetry run python exp_bandit_trend.py --players 128 --types 4
poetry run python exp_bandit_trend.py --players 128 --types 4

echo poetry run python exp_bandit_trend.py --players 8 --types 16 --rotate
poetry run python exp_bandit_trend.py --players 8 --types 16 --rotate
```
will produce 
![fig3](images/fig3.png)
![fig4](images/fig4.png)

### Individual rationality and budget balance with Best Mean Estimation
```
echo poetry run python exp_amd_bb_ir.py --players 8 --types 8
poetry run python exp_amd_bb_ir.py --players 8 --types 8

echo poetry run python exp_amd_bb_ir.py --players 8 --types 8 --IR
poetry run python exp_amd_bb_ir.py --players 8 --types 8 --IR
```
will produce 
![fig5](images/fig5.png)
![fig6](images/fig6.png)

```
for epsilon in 1.0 0.5 0.4 0.3 0.25 0.2 0.15
do
    echo poetry run python exp_rmse.py --players 8 --types 4 --epsilon $epsilon
    poetry run python exp_rmse.py --players 8 --types 4 --epsilon $epsilon
done

echo poetry run python exp_rmse.py --players 8 --types 4 --plot
poetry run python exp_rmse.py --players 8 --types 4 --plot
```
will produce 
![fig7](images/fig7.png)
